/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper.provider;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.tencent.bugly.proguard.ag;
import com.tencent.bugly.proguard.bf;
import com.tencent.bugly.proguard.we;
import com.tencent.rmonitor.base.thread.suspend.ThreadSuspend;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.looper.MonitorInfo;
import com.tencent.rmonitor.looper.listener.IMonitorCallback;
import com.tencent.rmonitor.looper.provider.BaseStackProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H&J\n\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0004J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rJ#\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H&\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010)\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/tencent/rmonitor/looper/provider/MultiStackProvider;", "Lcom/tencent/rmonitor/looper/provider/BaseStackProvider;", "Landroid/os/Handler$Callback;", "()V", "lastStackRequestTime", "", "monitorCallBack", "Lcom/tencent/rmonitor/looper/listener/IMonitorCallback;", "stackThreadHandler", "Landroid/os/Handler;", "beginTrace", "", "monitorInfo", "Lcom/tencent/rmonitor/looper/MonitorInfo;", "dispatchEnd", "endTime", "duration", "dispatchStart", "startTime", "endTrace", "isOverThreshold", "", "getStackThreadHandler", "handleCollectCompleted", "handleCollectStart", "handleMessage", "msg", "Landroid/os/Message;", "init", "callback", "isCurrentMsg", "onTrace", "stackTrace", "", "Ljava/lang/StackTraceElement;", "(Lcom/tencent/rmonitor/looper/MonitorInfo;[Ljava/lang/StackTraceElement;)V", "release", "removeMonitorMessage", "what", "", "sendMonitorMessage", "sendMonitorMessageDelay", "delay", "Companion", "bugly-pro_release"})
public abstract class MultiStackProvider
extends BaseStackProvider
implements Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "RMonitor_looper_StackProvider";
    public static final int MSG_COLLECT_START = 1;
    public static final int MSG_COLLECT_COMPLETED = 2;
    public static final long LONG_LAG_LIMIT = 5000L;
    @Nullable
    private Handler stackThreadHandler;
    @Nullable
    private IMonitorCallback monitorCallBack;
    private long lastStackRequestTime;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleCollectStart(MonitorInfo monitorInfo) {
        StackTraceElement[] stackTraceElementArray;
        String string;
        block10: {
            string = "handleCollectStart, deal msg not latest msg after trace, latest: ";
            if (!this.isCurrentMsg(monitorInfo)) {
                Logger.INSTANCE.d(TAG, "handleCollectStart, deal msg not latest msg before trace, latest: " + this.lastStackRequestTime + ", deal: " + monitorInfo.getLastStackRequestTime());
                return;
            }
            this.appendData(monitorInfo);
            long l10 = System.currentTimeMillis() - monitorInfo.getLastStackRequestTime();
            if (l10 > this.getLagParam().c) {
                long l11 = 5000L - l10;
                monitorInfo = monitorInfo.copy();
                monitorInfo.setDuration(Math.max(5000L, l10));
                monitorInfo.setDetectedLongLag(true);
                if (l11 <= 0L) {
                    this.handleCollectCompleted(monitorInfo);
                    return;
                }
                this.sendMonitorMessageDelay(2, monitorInfo, l11);
                return;
            }
            stackTraceElementArray = this.getLooperThread();
            if (stackTraceElementArray == null) return;
            if (!stackTraceElementArray.isAlive()) return;
            long l12 = 0L;
            if (this.shouldSuspendBeforeGetStack()) {
                l12 = ThreadSuspend.c().b((Thread)stackTraceElementArray);
            }
            stackTraceElementArray = stackTraceElementArray.getStackTrace();
            if (l12 == 0L) break block10;
            ThreadSuspend.c().a(l12);
        }
        if (this.isCurrentMsg(monitorInfo)) {
            MultiStackProvider multiStackProvider = this;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"stackTrace");
            multiStackProvider.onTrace(monitorInfo, stackTraceElementArray);
            multiStackProvider.sendMonitorMessageDelay(1, monitorInfo, this.getLagParam().d);
            return;
        }
        Logger logger = Logger.INSTANCE;
        String[] stringArray = new String[2];
        stringArray[0] = TAG;
        int n10 = 1;
        try {
            stringArray[n10] = string + this.lastStackRequestTime + ", deal: " + monitorInfo.getLastStackRequestTime();
            logger.d(stringArray);
            return;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.e(TAG, bf.a("on trace fail for ", throwable));
        }
    }

    private final void handleCollectCompleted(MonitorInfo monitorInfo) {
        MultiStackProvider multiStackProvider = iMonitorCallback;
        multiStackProvider.endTrace(monitorInfo, true);
        IMonitorCallback iMonitorCallback = multiStackProvider.monitorCallBack;
        if (iMonitorCallback != null) {
            iMonitorCallback.onAfterStack(monitorInfo);
        }
    }

    private final void sendMonitorMessage(int n10, MonitorInfo monitorInfo) {
        MultiStackProvider multiStackProvider = multiStackProvider2;
        MultiStackProvider multiStackProvider2 = Message.obtain();
        Message.obtain().what = n10;
        Message.obtain().obj = monitorInfo;
        Handler handler = multiStackProvider.stackThreadHandler;
        if (handler != null) {
            handler.sendMessage((Message)multiStackProvider2);
        }
    }

    private final void sendMonitorMessageDelay(int n10, MonitorInfo monitorInfo, long l10) {
        MultiStackProvider multiStackProvider = multiStackProvider2;
        MultiStackProvider multiStackProvider2 = Message.obtain();
        Message.obtain().what = n10;
        Message.obtain().obj = monitorInfo;
        Handler handler = multiStackProvider.stackThreadHandler;
        if (handler != null) {
            handler.sendMessageDelayed((Message)multiStackProvider2, l10);
        }
    }

    private final void removeMonitorMessage(int n10, MonitorInfo monitorInfo) {
        MultiStackProvider multiStackProvider = multiStackProvider.stackThreadHandler;
        if (multiStackProvider != null) {
            multiStackProvider.removeMessages(n10, monitorInfo);
        }
    }

    @Override
    public boolean init(@NotNull IMonitorCallback iMonitorCallback) {
        boolean bl;
        block4: {
            Handler handler;
            IMonitorCallback iMonitorCallback2 = iMonitorCallback;
            Intrinsics.checkNotNullParameter((Object)iMonitorCallback2, (String)"callback");
            this.monitorCallBack = iMonitorCallback2;
            bl = false;
            Looper looper = ag.a(this.getLooperThread());
            if (looper == null) break block4;
            MultiStackProvider multiStackProvider = this;
            Handler handler2 = handler;
            try {
                handler = new Handler(looper, (Handler.Callback)this);
                multiStackProvider.stackThreadHandler = handler2;
                bl = true;
            }
            catch (Exception exception) {
                Logger.INSTANCE.e(TAG, "prepare stack provider fail for exception {" + exception + '}');
            }
        }
        return bl;
    }

    @Override
    public void release() {
        Handler handler = this.stackThreadHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        this.stackThreadHandler = null;
        ag.e(this.getLooperThread());
        this.monitorCallBack = null;
    }

    @Override
    public void dispatchStart(@NotNull MonitorInfo monitorInfo, long l10) {
        MultiStackProvider multiStackProvider = this;
        MonitorInfo monitorInfo2 = monitorInfo;
        Intrinsics.checkNotNullParameter((Object)monitorInfo2, (String)"monitorInfo");
        this.lastStackRequestTime = monitorInfo2.getLastStackRequestTime();
        multiStackProvider.beginTrace(monitorInfo);
        l10 = multiStackProvider.getLagParam().d;
        multiStackProvider.sendMonitorMessageDelay(1, monitorInfo, l10);
    }

    @Override
    public void dispatchEnd(@NotNull MonitorInfo monitorInfo, long l10, long l11) {
        MultiStackProvider multiStackProvider = this;
        Intrinsics.checkNotNullParameter((Object)monitorInfo, (String)"monitorInfo");
        multiStackProvider.removeMonitorMessage(1, monitorInfo);
        if (l11 >= multiStackProvider.getLagParam().b) {
            this.appendData(monitorInfo);
            this.sendMonitorMessage(2, monitorInfo.copy());
        } else {
            this.endTrace(monitorInfo, false);
        }
        this.lastStackRequestTime = 0L;
    }

    public final boolean isCurrentMsg(@NotNull MonitorInfo monitorInfo) {
        Intrinsics.checkNotNullParameter((Object)monitorInfo, (String)"monitorInfo");
        long l10 = this.lastStackRequestTime;
        return l10 != 0L && l10 == monitorInfo.getLastStackRequestTime();
    }

    public boolean handleMessage(@NotNull Message message) {
        Message message2 = message;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"msg");
        Object object = message2.obj;
        object = object instanceof MonitorInfo ? (MonitorInfo)object : null;
        if (object == null) {
            return false;
        }
        int n10 = message.what;
        if (n10 != 1) {
            if (n10 == 2) {
                this.handleCollectCompleted((MonitorInfo)object);
            }
        } else {
            long l10 = SystemClock.uptimeMillis();
            long l11 = we.b();
            this.handleCollectStart((MonitorInfo)object);
            l11 = we.b() - l11;
            ((MonitorInfo)object).addCollectStackMsgSample(l10 - message.getWhen(), l11);
        }
        return true;
    }

    @Nullable
    public final Handler getStackThreadHandler() {
        return this.stackThreadHandler;
    }

    public abstract void beginTrace(@NotNull MonitorInfo var1);

    public abstract void onTrace(@NotNull MonitorInfo var1, @NotNull StackTraceElement[] var2);

    public abstract void endTrace(@NotNull MonitorInfo var1, boolean var2);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/tencent/rmonitor/looper/provider/MultiStackProvider$Companion;", "", "()V", "LONG_LAG_LIMIT", "", "MSG_COLLECT_COMPLETED", "", "MSG_COLLECT_START", "TAG", "", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

