/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.MetadataConstant;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

public final class CustomTransitiveMetadataResolver {
    private CustomTransitiveMetadataResolver() {
    }

    public static Map<String, String> resolve(ServerWebExchange exchange) {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpHeaders headers = exchange.getRequest().getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String sourceKey;
            String key = (String)entry.getKey();
            if (StringUtils.isBlank((String)key)) continue;
            if (StringUtils.startsWithIgnoreCase((String)key, (String)"X-SCT-Metadata-Transitive-") && !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) {
                sourceKey = StringUtils.substring((String)key, (int)MetadataConstant.SCT_TRANSITIVE_HEADER_PREFIX_LENGTH);
                result.put(sourceKey, (String)((List)entry.getValue()).get(0));
            }
            if (!StringUtils.startsWithIgnoreCase((String)key, (String)"X-Polaris-Metadata-Transitive-") || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            sourceKey = StringUtils.substring((String)key, (int)MetadataConstant.POLARIS_TRANSITIVE_HEADER_PREFIX_LENGTH);
            result.put(sourceKey, (String)((List)entry.getValue()).get(0));
        }
        return result;
    }

    public static Map<String, String> resolve(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String sourceKey;
            String key = (String)headers.nextElement();
            if (StringUtils.isBlank((String)key)) continue;
            if (StringUtils.startsWithIgnoreCase((String)key, (String)"X-SCT-Metadata-Transitive-") && StringUtils.isNotBlank((String)request.getHeader(key))) {
                sourceKey = StringUtils.substring((String)key, (int)MetadataConstant.SCT_TRANSITIVE_HEADER_PREFIX_LENGTH);
                result.put(sourceKey, request.getHeader(key));
            }
            if (!StringUtils.startsWithIgnoreCase((String)key, (String)"X-Polaris-Metadata-Transitive-") || !StringUtils.isNotBlank((String)request.getHeader(key))) continue;
            sourceKey = StringUtils.substring((String)key, (int)MetadataConstant.POLARIS_TRANSITIVE_HEADER_PREFIX_LENGTH);
            result.put(sourceKey, request.getHeader(key));
        }
        return result;
    }
}

