/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.constant.MetadataConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class EncodeTransferMedataFeignInterceptor
implements RequestInterceptor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(EncodeTransferMedataFeignInterceptor.class);

    public int getOrder() {
        return MetadataConstant.OrderConstant.METADATA_2_HEADER_INTERCEPTOR_ORDER;
    }

    public void apply(RequestTemplate requestTemplate) {
        MetadataContext metadataContext = MetadataContextHolder.get();
        Map customMetadata = metadataContext.getCustomMetadata();
        Map disposableMetadata = metadataContext.getDisposableMetadata();
        Map transHeaders = metadataContext.getTransHeadersKV();
        this.buildMetadataHeader(requestTemplate, disposableMetadata, "SCT-CUSTOM-DISPOSABLE-METADATA");
        this.buildMetadataHeader(requestTemplate, customMetadata, "SCT-CUSTOM-METADATA");
        this.buildTransmittedHeader(requestTemplate, transHeaders);
    }

    private void buildTransmittedHeader(RequestTemplate requestTemplate, Map<String, String> transHeaders) {
        if (!CollectionUtils.isEmpty(transHeaders)) {
            transHeaders.entrySet().stream().forEach(entry -> {
                requestTemplate.removeHeader((String)entry.getKey());
                requestTemplate.header((String)entry.getKey(), new String[]{(String)entry.getValue()});
            });
        }
    }

    private void buildMetadataHeader(RequestTemplate requestTemplate, Map<String, String> metadata, String headerName) {
        if (!CollectionUtils.isEmpty(metadata)) {
            String encodedMetadata = JacksonUtils.serialize2Json(metadata);
            requestTemplate.removeHeader(headerName);
            try {
                requestTemplate.header(headerName, new String[]{URLEncoder.encode(encodedMetadata, ContextConstant.UTF_8)});
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Set header failed.", (Throwable)e);
                requestTemplate.header(headerName, new String[]{encodedMetadata});
            }
        }
    }
}

