/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.constant.MetadataConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class EncodeTransferMedataRestTemplateInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    public int getOrder() {
        return MetadataConstant.OrderConstant.METADATA_2_HEADER_INTERCEPTOR_ORDER;
    }

    public ClientHttpResponse intercept(@NonNull HttpRequest httpRequest, @NonNull byte[] bytes, @NonNull ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        MetadataContext metadataContext = MetadataContextHolder.get();
        Map customMetadata = metadataContext.getCustomMetadata();
        Map disposableMetadata = metadataContext.getDisposableMetadata();
        Map transHeaders = metadataContext.getTransHeadersKV();
        this.buildMetadataHeader(httpRequest, disposableMetadata, "SCT-CUSTOM-DISPOSABLE-METADATA");
        this.buildMetadataHeader(httpRequest, customMetadata, "SCT-CUSTOM-METADATA");
        this.buildTransmittedHeader(httpRequest, transHeaders);
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }

    private void buildTransmittedHeader(HttpRequest request, Map<String, String> transHeaders) {
        if (!CollectionUtils.isEmpty(transHeaders)) {
            transHeaders.entrySet().stream().forEach(entry -> request.getHeaders().set((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void buildMetadataHeader(HttpRequest request, Map<String, String> metadata, String headerName) {
        if (!CollectionUtils.isEmpty(metadata)) {
            String encodedMetadata = JacksonUtils.serialize2Json(metadata);
            try {
                request.getHeaders().set(headerName, URLEncoder.encode(encodedMetadata, ContextConstant.UTF_8));
            }
            catch (UnsupportedEncodingException e) {
                request.getHeaders().set(headerName, encodedMetadata);
            }
        }
    }
}

