/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;

public final class TransHeadersTransfer {
    private TransHeadersTransfer() {
    }

    public static void transfer(HttpServletRequest httpServletRequest) {
        Map transHeaderMetadata = MetadataContextHolder.get().getTransHeaders();
        if (!CollectionUtils.isEmpty((Map)transHeaderMetadata)) {
            String transHeaders = transHeaderMetadata.keySet().stream().findFirst().orElse("");
            String[] transHeaderArray = transHeaders.split(",");
            Enumeration httpHeaders = httpServletRequest.getHeaderNames();
            while (httpHeaders.hasMoreElements()) {
                String httpHeader = (String)httpHeaders.nextElement();
                Arrays.stream(transHeaderArray).forEach(transHeader -> {
                    if (transHeader.equals(httpHeader)) {
                        String httpHeaderValue = httpServletRequest.getHeader(httpHeader);
                        MetadataContextHolder.get().setTransHeadersKV(httpHeader, httpHeaderValue);
                    }
                });
            }
        }
    }

    public static void transfer(ServerHttpRequest serverHttpRequest) {
        Map transHeaderMetadata = MetadataContextHolder.get().getTransHeaders();
        if (!CollectionUtils.isEmpty((Map)transHeaderMetadata)) {
            String transHeaders = transHeaderMetadata.keySet().stream().findFirst().orElse("");
            String[] transHeaderArray = transHeaders.split(",");
            HttpHeaders headers = serverHttpRequest.getHeaders();
            Set headerKeys = headers.keySet();
            for (String httpHeader : headerKeys) {
                Arrays.stream(transHeaderArray).forEach(transHeader -> {
                    if (transHeader.equals(httpHeader)) {
                        List list = headers.get((Object)httpHeader);
                        String httpHeaderValue = JacksonUtils.serialize2Json((Object)list);
                        MetadataContextHolder.get().setTransHeadersKV(httpHeader, httpHeaderValue);
                    }
                });
            }
        }
    }
}

