/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config;

import com.tencent.cloud.polaris.config.ConditionalOnPolarisConfigEnabled;
import com.tencent.cloud.polaris.config.adapter.AffectedConfigurationPropertiesRebinder;
import com.tencent.cloud.polaris.config.adapter.PolarisConfigPropertyRefresher;
import com.tencent.cloud.polaris.config.adapter.PolarisConfigRefreshScopeAnnotationDetector;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.adapter.PolarisRefreshAffectedContextRefresher;
import com.tencent.cloud.polaris.config.adapter.PolarisRefreshEntireContextRefresher;
import com.tencent.cloud.polaris.config.annotation.PolarisConfigAnnotationProcessor;
import com.tencent.cloud.polaris.config.condition.ConditionalOnReflectRefreshType;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.listener.PolarisConfigChangeEventListener;
import com.tencent.cloud.polaris.config.listener.PolarisConfigRefreshOptimizationListener;
import com.tencent.cloud.polaris.config.logger.PolarisConfigLoggerApplicationListener;
import com.tencent.cloud.polaris.config.spring.annotation.SpringValueProcessor;
import com.tencent.cloud.polaris.config.spring.property.PlaceholderHelper;
import com.tencent.cloud.polaris.config.spring.property.SpringValueRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisConfigEnabled
public class PolarisConfigAutoConfiguration {
    @Bean
    public PolarisConfigAnnotationProcessor polarisConfigAnnotationProcessor() {
        return new PolarisConfigAnnotationProcessor();
    }

    @Bean
    public PolarisConfigChangeEventListener polarisConfigChangeEventListener() {
        return new PolarisConfigChangeEventListener();
    }

    @Bean
    public PolarisConfigLoggerApplicationListener polarisConfigLoggerApplicationListener() {
        return new PolarisConfigLoggerApplicationListener();
    }

    @Bean
    @Primary
    @ConditionalOnReflectRefreshType
    public ConfigurationPropertiesRebinder affectedConfigurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        return new AffectedConfigurationPropertiesRebinder(beans);
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public PolarisConfigPropertyRefresher polarisRefreshContextPropertySourceAutoRefresher(PolarisConfigProperties polarisConfigProperties, PolarisPropertySourceManager polarisPropertySourceManager, ContextRefresher contextRefresher) {
        return new PolarisRefreshEntireContextRefresher(polarisConfigProperties, polarisPropertySourceManager, contextRefresher);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReflectRefreshType
    @AutoConfigureBefore(value={PolarisConfigAutoConfiguration.class})
    public static class PolarisReflectRefresherAutoConfiguration {
        @Bean
        public SpringValueRegistry springValueRegistry() {
            return new SpringValueRegistry();
        }

        @Bean
        public PlaceholderHelper placeholderHelper() {
            return new PlaceholderHelper();
        }

        @Bean
        public SpringValueProcessor springValueProcessor(PlaceholderHelper placeholderHelper, SpringValueRegistry springValueRegistry, PolarisConfigProperties polarisConfigProperties) {
            return new SpringValueProcessor(placeholderHelper, springValueRegistry, polarisConfigProperties);
        }

        @Bean
        public PolarisConfigPropertyRefresher polarisReflectPropertySourceAutoRefresher(PolarisConfigProperties polarisConfigProperties, PolarisPropertySourceManager polarisPropertySourceManager, SpringValueRegistry springValueRegistry, PlaceholderHelper placeholderHelper) {
            return new PolarisRefreshAffectedContextRefresher(polarisConfigProperties, polarisPropertySourceManager, springValueRegistry, placeholderHelper);
        }

        @Bean
        public PolarisConfigRefreshScopeAnnotationDetector polarisConfigRefreshScopeAnnotationDetector() {
            return new PolarisConfigRefreshScopeAnnotationDetector();
        }

        @Bean
        public PolarisConfigRefreshOptimizationListener polarisConfigRefreshOptimizationListener() {
            return new PolarisConfigRefreshOptimizationListener();
        }
    }
}

