/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigCustomExtensionLayer;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySource;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.adapter.PolarisServiceLoaderUtil;
import com.tencent.cloud.polaris.config.config.ConfigFileGroup;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.enums.ConfigFileFormat;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0)
public class PolarisConfigFileLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigFileLocator.class);
    private static final String POLARIS_CONFIG_PROPERTY_SOURCE_NAME = "polaris-config";
    private final PolarisConfigProperties polarisConfigProperties;
    private final PolarisContextProperties polarisContextProperties;
    private final ConfigFileService configFileService;
    private final PolarisPropertySourceManager polarisPropertySourceManager;
    private final Environment environment;
    private final PolarisConfigCustomExtensionLayer polarisConfigCustomExtensionLayer = PolarisServiceLoaderUtil.getPolarisConfigCustomExtensionLayer();

    public PolarisConfigFileLocator(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties, ConfigFileService configFileService, PolarisPropertySourceManager polarisPropertySourceManager, Environment environment) {
        this.polarisConfigProperties = polarisConfigProperties;
        this.polarisContextProperties = polarisContextProperties;
        this.configFileService = configFileService;
        this.polarisPropertySourceManager = polarisPropertySourceManager;
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySource<?> locate(Environment environment) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(POLARIS_CONFIG_PROPERTY_SOURCE_NAME);
        try {
            this.initCustomPolarisConfigExtensionFiles(compositePropertySource);
            this.initInternalConfigFiles(compositePropertySource);
            List<ConfigFileGroup> configFileGroups = this.polarisConfigProperties.getGroups();
            if (CollectionUtils.isEmpty(configFileGroups)) {
                CompositePropertySource compositePropertySource2 = compositePropertySource;
                return compositePropertySource2;
            }
            this.initCustomPolarisConfigFiles(compositePropertySource, configFileGroups);
            CompositePropertySource compositePropertySource3 = compositePropertySource;
            return compositePropertySource3;
        }
        finally {
            this.afterLocatePolarisConfigExtension(compositePropertySource);
        }
    }

    private void initCustomPolarisConfigExtensionFiles(CompositePropertySource compositePropertySource) {
        if (this.polarisConfigCustomExtensionLayer == null) {
            LOGGER.debug("[SCT Config] PolarisAdaptorTsfConfigExtensionLayer is not init, ignore the following execution steps");
            return;
        }
        this.polarisConfigCustomExtensionLayer.initConfigFiles(this.environment, compositePropertySource, this.polarisPropertySourceManager, this.configFileService);
    }

    private void afterLocatePolarisConfigExtension(CompositePropertySource compositePropertySource) {
        if (this.polarisConfigCustomExtensionLayer == null) {
            LOGGER.debug("[SCT Config] PolarisAdaptorTsfConfigExtensionLayer is not init, ignore the following execution steps");
            return;
        }
        this.polarisConfigCustomExtensionLayer.executeAfterLocateConfigReturning(compositePropertySource);
    }

    private void initInternalConfigFiles(CompositePropertySource compositePropertySource) {
        List<ConfigFileMetadata> internalConfigFiles = this.getInternalConfigFiles();
        for (ConfigFileMetadata configFile : internalConfigFiles) {
            PolarisPropertySource polarisPropertySource = this.loadPolarisPropertySource(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
            compositePropertySource.addPropertySource((PropertySource)polarisPropertySource);
            this.polarisPropertySourceManager.addPropertySource(polarisPropertySource);
            LOGGER.info("[SCT Config] Load and inject polaris config file. file = {}", (Object)configFile);
        }
    }

    private List<ConfigFileMetadata> getInternalConfigFiles() {
        String namespace = this.polarisContextProperties.getNamespace();
        String serviceName = this.polarisContextProperties.getService();
        if (!StringUtils.hasText((String)serviceName)) {
            serviceName = this.environment.getProperty("spring.application.name");
        }
        LinkedList<ConfigFileMetadata> internalConfigFiles = new LinkedList<ConfigFileMetadata>();
        Object[] activeProfiles = this.environment.getActiveProfiles();
        Object[] defaultProfiles = this.environment.getDefaultProfiles();
        ArrayList<String> profileList = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])activeProfiles)) {
            profileList.addAll(Arrays.asList(activeProfiles));
        } else if (ArrayUtils.isNotEmpty((Object[])defaultProfiles)) {
            profileList.addAll(Arrays.asList(defaultProfiles));
        }
        this.buildInternalApplicationConfigFiles(internalConfigFiles, namespace, serviceName, profileList);
        this.buildInternalBootstrapConfigFiles(internalConfigFiles, namespace, serviceName, profileList);
        return internalConfigFiles;
    }

    private void buildInternalApplicationConfigFiles(List<ConfigFileMetadata> internalConfigFiles, String namespace, String serviceName, List<String> profileList) {
        for (String profile : profileList) {
            if (!StringUtils.hasText((String)profile)) continue;
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application-" + profile + ".properties"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application-" + profile + ".yml"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application-" + profile + ".yaml"));
        }
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application.properties"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application.yml"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application.yaml"));
    }

    private void buildInternalBootstrapConfigFiles(List<ConfigFileMetadata> internalConfigFiles, String namespace, String serviceName, List<String> profileList) {
        for (String profile : profileList) {
            if (!StringUtils.hasText((String)profile)) continue;
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap-" + profile + ".properties"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap-" + profile + ".yml"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap-" + profile + ".yaml"));
        }
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap.properties"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap.yml"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap.yaml"));
    }

    private void initCustomPolarisConfigFiles(CompositePropertySource compositePropertySource, List<ConfigFileGroup> configFileGroups) {
        String namespace = this.polarisContextProperties.getNamespace();
        for (ConfigFileGroup configFileGroup : configFileGroups) {
            String group = configFileGroup.getName();
            if (!StringUtils.hasText((String)group)) {
                throw new IllegalArgumentException("polaris config group name cannot be empty.");
            }
            List<String> files = configFileGroup.getFiles();
            if (CollectionUtils.isEmpty(files)) {
                return;
            }
            for (String fileName : files) {
                PolarisPropertySource polarisPropertySource = this.loadPolarisPropertySource(namespace, group, fileName);
                compositePropertySource.addPropertySource((PropertySource)polarisPropertySource);
                this.polarisPropertySourceManager.addPropertySource(polarisPropertySource);
                LOGGER.info("[SCT Config] Load and inject polaris config file success. namespace = {}, group = {}, fileName = {}", new Object[]{namespace, group, fileName});
            }
        }
    }

    private PolarisPropertySource loadPolarisPropertySource(String namespace, String group, String fileName) {
        ConfigKVFile configKVFile;
        if (ConfigFileFormat.isPropertyFile(fileName) || ConfigFileFormat.isUnknownFile(fileName)) {
            configKVFile = this.configFileService.getConfigPropertiesFile(namespace, group, fileName);
        } else if (ConfigFileFormat.isYamlFile(fileName)) {
            configKVFile = this.configFileService.getConfigYamlFile(namespace, group, fileName);
        } else {
            LOGGER.warn("[SCT Config] Unsupported config file. namespace = {}, group = {}, fileName = {}", new Object[]{namespace, group, fileName});
            throw new IllegalStateException("Only configuration files in the format of properties / yaml / yaml can be injected into the spring context");
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        for (String key : configKVFile.getPropertyNames()) {
            map.put(key, configKVFile.getProperty(key, null));
        }
        return new PolarisPropertySource(namespace, group, fileName, configKVFile, map);
    }
}

