/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.lang.NonNull;

public class PolarisConfigRefreshScopeAnnotationDetector
implements BeanPostProcessor,
InitializingBean,
PriorityOrdered {
    private final AtomicBoolean isRefreshScopeAnnotationUsed = new AtomicBoolean(false);
    private Class refreshScopeAnnotationClass;
    private String annotatedRefreshScopeBeanName;

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (this.isRefreshScopeAnnotationUsed() || this.refreshScopeAnnotationClass == null) {
            return bean;
        }
        Annotation[] refreshScopeAnnotations = bean.getClass().getAnnotationsByType(this.refreshScopeAnnotationClass);
        if (refreshScopeAnnotations.length > 0 && this.isRefreshScopeAnnotationUsed.compareAndSet(false, true)) {
            this.annotatedRefreshScopeBeanName = beanName;
        }
        return bean;
    }

    public void afterPropertiesSet() {
        try {
            this.refreshScopeAnnotationClass = Class.forName("org.springframework.cloud.context.config.annotation.RefreshScope", false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public boolean isRefreshScopeAnnotationUsed() {
        return this.isRefreshScopeAnnotationUsed.get();
    }

    public String getAnnotatedRefreshScopeBeanName() {
        return this.annotatedRefreshScopeBeanName;
    }
}

