/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.tencent.cloud.polaris.config.annotation.PolarisConfigKVFileChangeListener;
import com.tencent.cloud.polaris.config.listener.ConfigChangeEvent;
import com.tencent.cloud.polaris.config.listener.PolarisConfigListenerContext;
import com.tencent.cloud.polaris.config.listener.SyncConfigChangeListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class PolarisConfigAnnotationProcessor
implements BeanPostProcessor,
PriorityOrdered {
    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        for (Method method : this.findAllMethod(clazz)) {
            this.processPolarisConfigChangeListener(bean, method);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private List<Method> findAllMethod(Class<?> clazz) {
        LinkedList<Method> res = new LinkedList<Method>();
        ReflectionUtils.doWithMethods(clazz, res::add);
        return res;
    }

    private void processPolarisConfigChangeListener(final Object bean, final Method method) {
        PolarisConfigKVFileChangeListener annotation = (PolarisConfigKVFileChangeListener)AnnotationUtils.findAnnotation((Method)method, PolarisConfigKVFileChangeListener.class);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (int)parameterTypes.length, (Object)method);
        Preconditions.checkArgument((boolean)ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", parameterTypes[0], (Object)method);
        ReflectionUtils.makeAccessible((Method)method);
        Object[] annotatedInterestedKeys = annotation.interestedKeys();
        Object[] annotatedInterestedKeyPrefixes = annotation.interestedKeyPrefixes();
        final boolean isAsync = annotation.async();
        SyncConfigChangeListener configChangeListener = new SyncConfigChangeListener(){

            @Override
            public void onChange(ConfigChangeEvent changeEvent) {
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{changeEvent});
            }

            @Override
            public boolean isAsync() {
                return isAsync;
            }
        };
        HashSet interestedKeys = annotatedInterestedKeys.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeys) : null;
        HashSet interestedKeyPrefixes = annotatedInterestedKeyPrefixes.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeyPrefixes) : null;
        PolarisConfigListenerContext.addChangeListener(configChangeListener, interestedKeys, interestedKeyPrefixes);
    }
}

