/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.enums;

public enum ConfigFileFormat {
    PROPERTY(".properties"),
    YAML(".yaml"),
    YML(".yml"),
    XML(".xml"),
    JSON(".json"),
    TEXT(".txt"),
    html(".html"),
    UNKNOWN(".unknown");

    private final String extension;

    private ConfigFileFormat(String extension) {
        this.extension = extension;
    }

    public static boolean isPropertyFile(String fileName) {
        return fileName.endsWith(ConfigFileFormat.PROPERTY.extension);
    }

    public static boolean isYamlFile(String fileName) {
        return fileName.endsWith(ConfigFileFormat.YAML.extension) || fileName.endsWith(ConfigFileFormat.YML.extension);
    }

    public static boolean isUnknownFile(String fileName) {
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!fileName.endsWith(format.extension)) continue;
            return false;
        }
        return true;
    }
}

