/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.listener;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigRefreshScopeAnnotationDetector;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.adapter.PolarisRefreshEntireContextRefresher;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.enums.RefreshType;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.NonNull;

public class PolarisConfigRefreshOptimizationListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigRefreshOptimizationListener.class);
    private static final String CONFIG_REFRESH_TYPE_PROPERTY = "configRefreshTypeProperty";
    private static final String REFLECT_REBINDER_BEAN_NAME = "affectedConfigurationPropertiesRebinder";
    private static final String REFLECT_REFRESHER_BEAN_NAME = "polarisReflectPropertySourceAutoRefresher";
    private static final String REFRESH_CONTEXT_REFRESHER_BEAN_NAME = "polarisRefreshContextPropertySourceAutoRefresher";

    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)event.getApplicationContext();
        PolarisConfigRefreshScopeAnnotationDetector detector = (PolarisConfigRefreshScopeAnnotationDetector)applicationContext.getBean(PolarisConfigRefreshScopeAnnotationDetector.class);
        boolean isRefreshScopeAnnotationUsed = detector.isRefreshScopeAnnotationUsed();
        String annotatedRefreshScopeBeanName = detector.getAnnotatedRefreshScopeBeanName();
        String value = System.getProperty("spring.cloud.polaris.config.refresh-type");
        boolean isSystemSetRefreshType = RefreshType.REFRESH_CONTEXT.toString().equalsIgnoreCase(value);
        if (isRefreshScopeAnnotationUsed || isSystemSetRefreshType) {
            if (isRefreshScopeAnnotationUsed) {
                LOGGER.warn("Detected that the bean [{}] is using @RefreshScope annotation, but the config refresh type is still [reflect]. [SCT] will automatically switch to [refresh_context].", (Object)annotatedRefreshScopeBeanName);
            }
            if (isSystemSetRefreshType) {
                LOGGER.warn("Detected that using System.setProperty to set spring.cloud.polaris.config.refresh-type = refresh_context, but the config refresh type is still [reflect]. [SCT] will automatically switch to [refresh_context].");
            }
            this.switchConfigRefreshTypeProperty(applicationContext);
            this.modifyPolarisConfigPropertiesBean(applicationContext);
            this.removeRelatedBeansOfReflect(applicationContext);
            this.registerRefresherBeanOfRefreshContext(applicationContext);
            this.addRefresherBeanAsListener(applicationContext);
        }
    }

    private void switchConfigRefreshTypeProperty(ConfigurableApplicationContext applicationContext) {
        MutablePropertySources propertySources = applicationContext.getEnvironment().getPropertySources();
        propertySources.addFirst((PropertySource)new MapPropertySource(CONFIG_REFRESH_TYPE_PROPERTY, Collections.singletonMap("spring.cloud.polaris.config.refresh-type", RefreshType.REFRESH_CONTEXT)));
    }

    private void modifyPolarisConfigPropertiesBean(ConfigurableApplicationContext applicationContext) {
        PolarisConfigProperties polarisConfigProperties = (PolarisConfigProperties)applicationContext.getBean(PolarisConfigProperties.class);
        polarisConfigProperties.setRefreshType(RefreshType.REFRESH_CONTEXT);
    }

    private void removeRelatedBeansOfReflect(ConfigurableApplicationContext applicationContext) {
        try {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
            beanFactory.removeBeanDefinition(REFLECT_REFRESHER_BEAN_NAME);
            beanFactory.removeBeanDefinition(REFLECT_REBINDER_BEAN_NAME);
        }
        catch (BeansException e) {
            LOGGER.debug("removeRelatedBeansOfReflect occur error:", (Throwable)e);
        }
    }

    private void registerRefresherBeanOfRefreshContext(ConfigurableApplicationContext applicationContext) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition().getBeanDefinition();
        beanDefinition.setBeanClass(PolarisRefreshEntireContextRefresher.class);
        PolarisConfigProperties polarisConfigProperties = (PolarisConfigProperties)beanFactory.getBean(PolarisConfigProperties.class);
        PolarisPropertySourceManager polarisPropertySourceManager = (PolarisPropertySourceManager)beanFactory.getBean(PolarisPropertySourceManager.class);
        ContextRefresher contextRefresher = (ContextRefresher)beanFactory.getBean(ContextRefresher.class);
        ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
        constructorArgumentValues.addIndexedArgumentValue(0, (Object)polarisConfigProperties);
        constructorArgumentValues.addIndexedArgumentValue(1, (Object)polarisPropertySourceManager);
        constructorArgumentValues.addIndexedArgumentValue(2, (Object)contextRefresher);
        beanFactory.registerBeanDefinition(REFRESH_CONTEXT_REFRESHER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private void addRefresherBeanAsListener(ConfigurableApplicationContext applicationContext) {
        PolarisRefreshEntireContextRefresher refresher = (PolarisRefreshEntireContextRefresher)applicationContext.getBean(REFRESH_CONTEXT_REFRESHER_BEAN_NAME);
        applicationContext.addApplicationListener((ApplicationListener)refresher);
    }
}

