/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.logger;

import com.tencent.cloud.polaris.config.logger.PolarisConfigLoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class PolarisConfigLoggerApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigLoggerApplicationListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        try {
            if (event instanceof ApplicationStartedEvent) {
                ApplicationStartedEvent startedEvent = (ApplicationStartedEvent)event;
                ClassLoader classLoader = startedEvent.getSpringApplication().getClassLoader();
                LoggingSystem loggingSystem = LoggingSystem.get((ClassLoader)classLoader);
                LOGGER.info("PolarisConfigLoggerApplicationListener onApplicationEvent init loggingSystem:{}", (Object)loggingSystem);
                PolarisConfigLoggerContext.setLogSystem(loggingSystem);
            }
        }
        catch (Exception e) {
            LOGGER.error("PolarisConfigLoggerApplicationListener onApplicationEvent exception:", (Throwable)e);
        }
    }
}

