/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.logger;

import com.tencent.cloud.polaris.config.logger.Level;
import com.tencent.cloud.polaris.config.logger.StdLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.util.Assert;

public final class PolarisConfigLoggerContext {
    private static LoggingSystem loggingSystem;

    private PolarisConfigLoggerContext() {
    }

    protected static void setLogSystem(LoggingSystem logSystem) {
        Assert.notNull((Object)logSystem, (String)"Logging System should not be null");
        loggingSystem = logSystem;
    }

    public static void setLevel(String loggerName, String level) {
        if (loggingSystem == null) {
            PolarisConfigLoggerContext.printLog("[SCT Config] PolarisConfigLoggerContext logger: [" + loggerName + "] change to target level fail. caused by internal exception:" + level, Level.WARN);
            return;
        }
        Level loggerLevel = Level.levelOf(level);
        if (loggerLevel == null) {
            PolarisConfigLoggerContext.printLog("[SCT Config] PolarisConfigLoggerContext logger: [" + loggerName + "] change to target level fail. caused by level is not support, level:" + level, Level.WARN);
            return;
        }
        LogLevel logLevel = null;
        switch (loggerLevel) {
            case TRACE: {
                logLevel = LogLevel.TRACE;
                break;
            }
            case DEBUG: {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case OFF: {
                logLevel = LogLevel.OFF;
                break;
            }
            case INFO: {
                logLevel = LogLevel.INFO;
                break;
            }
            case WARN: {
                logLevel = LogLevel.WARN;
                break;
            }
            case ERROR: {
                logLevel = LogLevel.ERROR;
                break;
            }
            case FATAL: {
                logLevel = LogLevel.FATAL;
                break;
            }
            default: {
                PolarisConfigLoggerContext.printLog("[SCT Config] PolarisConfigLoggerContext logger: [" + loggerName + "] setLevel fail. caused by level is not support, level: " + level, Level.WARN);
            }
        }
        loggingSystem.setLogLevel(loggerName, logLevel);
        PolarisConfigLoggerContext.printLog("[SCT Config] PolarisConfigLoggerContext logger: [" + loggerName + "] changed to level:" + level, Level.INFO);
    }

    private static void printLog(String message, Level level) {
        Logger logger = LoggerFactory.getLogger((String)"ROOT");
        if (level.ordinal() <= Level.INFO.ordinal()) {
            if (logger != null) {
                logger.info(message);
            } else {
                StdLog.info(message);
            }
        } else if (logger != null) {
            logger.warn(message);
        } else {
            StdLog.warn(message);
        }
    }
}

