/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.logger;

import java.io.PrintStream;
import java.util.Calendar;

public final class StdLog {
    private static final String CLASS_INFO = StdLog.class.getName();
    protected static boolean debugEnabled = false;
    protected static boolean infoEnabled = true;
    protected static boolean quietMode = false;
    private static final String DEBUG_FIX = "StdLog:DEBUG: ";
    private static final String INFO_FIX = "StdLog:INFO: ";
    private static final String WARN_FIX = "StdLog:WARN: ";

    private StdLog() {
    }

    public static void setQuietMode(boolean quietMode) {
        StdLog.quietMode = quietMode;
    }

    public static void setInfoEnabled(boolean infoEnabled) {
        StdLog.infoEnabled = infoEnabled;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        StdLog.debugEnabled = debugEnabled;
    }

    public static void debug(String msg) {
        if (debugEnabled && !quietMode) {
            StdLog.println(System.out, DEBUG_FIX + msg);
        }
    }

    public static void info(String msg) {
        if (infoEnabled && !quietMode) {
            StdLog.println(System.out, INFO_FIX + msg);
        }
    }

    public static void warn(String msg) {
        if (infoEnabled && !quietMode) {
            StdLog.println(System.err, WARN_FIX + msg);
        }
    }

    public static void warn(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        StdLog.println(System.err, WARN_FIX + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private static void println(PrintStream out, String msg) {
        out.println(Calendar.getInstance().getTime().toString() + " " + CLASS_INFO + " " + msg);
    }
}

