/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.common.util.ReflectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AffectedConfigurationPropertiesRebinder
extends ConfigurationPropertiesRebinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AffectedConfigurationPropertiesRebinder.class);
    private ApplicationContext applicationContext;
    private Map<String, ConfigurationPropertiesBean> propertiesBeans = new HashMap<String, ConfigurationPropertiesBean>();
    private final Map<String, Map<String, Object>> propertiesBeanDefaultValues = new ConcurrentHashMap<String, Map<String, Object>>();

    public AffectedConfigurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        super(beans);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
        this.propertiesBeans = ConfigurationPropertiesBean.getAll((ApplicationContext)applicationContext);
        this.initPropertiesBeanDefaultValues(this.propertiesBeans);
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.applicationContext.equals(event.getSource())) {
            this.rebindAffectedBeans(event);
        }
    }

    private void rebindAffectedBeans(EnvironmentChangeEvent event) {
        Set changedKeys = event.getKeys();
        if (CollectionUtils.isEmpty((Collection)changedKeys)) {
            return;
        }
        this.propertiesBeans.forEach((name, bean) -> changedKeys.forEach(key -> {
            String propertiesPrefix = Objects.requireNonNull(AnnotationUtils.getValue((Annotation)bean.getAnnotation())).toString();
            if (key.startsWith(propertiesPrefix)) {
                this.rebind((String)name);
                this.rebindDefaultValue((String)name, (String)key);
            }
        }));
    }

    private void rebindDefaultValue(String beanName, String key) {
        String changeValue = this.applicationContext.getEnvironment().getProperty(key);
        if (StringUtils.hasLength((String)changeValue)) {
            return;
        }
        Map<String, Object> defaultValues = this.propertiesBeanDefaultValues.get(beanName);
        if (MapUtils.isEmpty(defaultValues)) {
            return;
        }
        try {
            String fieldName = key.substring(key.lastIndexOf(".") + 1);
            Object bean = this.applicationContext.getBean(beanName);
            Field field = ReflectionUtils.findField(bean.getClass(), (String)fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(bean, defaultValues.get(fieldName));
            }
        }
        catch (Exception e) {
            LOGGER.error("[SCT Config] rebind default value error, bean = {}, key = {}", (Object)beanName, (Object)key);
        }
    }

    private void initPropertiesBeanDefaultValues(Map<String, ConfigurationPropertiesBean> propertiesBeans) {
        if (MapUtils.isEmpty(propertiesBeans)) {
            return;
        }
        for (ConfigurationPropertiesBean propertiesBean : propertiesBeans.values()) {
            HashMap defaultValues = new HashMap();
            try {
                Object instance = propertiesBean.getInstance().getClass().getDeclaredConstructor(null).newInstance(new Object[0]);
                ReflectionUtils.doWithFields(instance.getClass(), field -> {
                    try {
                        field.setAccessible(true);
                        defaultValues.put(field.getName(), field.get(instance));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, field -> {
                    int modifiers = field.getModifiers();
                    return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && ReflectionUtils.writableBeanField((Field)field);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.propertiesBeanDefaultValues.put(propertiesBean.getName(), defaultValues);
        }
    }
}

