/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigPropertyRefresher;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySource;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.polaris.configuration.api.core.ConfigPropertyChangeInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public abstract class PolarisConfigPropertyAutoRefresher
implements ApplicationListener<ApplicationReadyEvent>,
PolarisConfigPropertyRefresher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigPropertyAutoRefresher.class);
    private final PolarisConfigProperties polarisConfigProperties;
    private final PolarisPropertySourceManager polarisPropertySourceManager;
    private final AtomicBoolean registered = new AtomicBoolean(false);

    public PolarisConfigPropertyAutoRefresher(PolarisConfigProperties polarisConfigProperties, PolarisPropertySourceManager polarisPropertySourceManager) {
        this.polarisConfigProperties = polarisConfigProperties;
        this.polarisPropertySourceManager = polarisPropertySourceManager;
    }

    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        this.registerPolarisConfigPublishEvent();
    }

    private void registerPolarisConfigPublishEvent() {
        if (!this.polarisConfigProperties.isAutoRefresh()) {
            return;
        }
        List<PolarisPropertySource> polarisPropertySources = this.polarisPropertySourceManager.getAllPropertySources();
        if (CollectionUtils.isEmpty(polarisPropertySources)) {
            return;
        }
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        for (PolarisPropertySource polarisPropertySource : polarisPropertySources) {
            polarisPropertySource.getConfigKVFile().addChangeListener(configKVFileChangeEvent -> {
                LOGGER.info("[SCT Config] received polaris config change event and will refresh spring context. namespace = {}, group = {}, fileName = {}", new Object[]{polarisPropertySource.getNamespace(), polarisPropertySource.getGroup(), polarisPropertySource.getFileName()});
                Map source = (Map)polarisPropertySource.getSource();
                for (String changedKey : configKVFileChangeEvent.changedKeys()) {
                    ConfigPropertyChangeInfo configPropertyChangeInfo = configKVFileChangeEvent.getChangeInfo(changedKey);
                    LOGGER.info("[SCT Config] changed property = {}", (Object)configPropertyChangeInfo);
                    switch (configPropertyChangeInfo.getChangeType()) {
                        case MODIFIED: 
                        case ADDED: {
                            source.put(changedKey, configPropertyChangeInfo.getNewValue());
                            break;
                        }
                        case DELETED: {
                            source.remove(changedKey);
                        }
                    }
                    this.refreshSpringValue(changedKey);
                }
                this.refreshConfigurationProperties(configKVFileChangeEvent.changedKeys());
            });
        }
    }
}

