/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.spring.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public abstract class PolarisProcessor
implements BeanPostProcessor,
PriorityOrdered {
    public Object postProcessBeforeInitialization(Object bean, @NonNull String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        for (Field field : this.findAllField(clazz)) {
            this.processField(bean, beanName, field);
        }
        for (Method method : this.findAllMethod(clazz)) {
            this.processMethod(bean, beanName, method);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    protected abstract void processField(Object var1, String var2, Field var3);

    protected abstract void processMethod(Object var1, String var2, Method var3);

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private List<Field> findAllField(Class<?> clazz) {
        LinkedList<Field> res = new LinkedList<Field>();
        ReflectionUtils.doWithFields(clazz, res::add);
        return res;
    }

    private List<Method> findAllMethod(Class<?> clazz) {
        LinkedList<Method> res = new LinkedList<Method>();
        ReflectionUtils.doWithMethods(clazz, res::add);
        return res;
    }
}

