/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.loadbalancer.PolarisLoadBalancerClientConfiguration;
import com.tencent.cloud.rpc.enhancement.resttemplate.EnhancedRestTemplateInterceptor;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnDiscoveryEnabled
@ConditionalOnPolarisEnabled
@ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@LoadBalancerClients(defaultConfiguration={PolarisLoadBalancerClientConfiguration.class})
public class PolarisLoadBalancerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestTemplateCustomizer restTemplateCustomizer(@Autowired(required=false) LoadBalancerInterceptor loadBalancerInterceptor) {
        return restTemplate -> {
            ArrayList<LoadBalancerInterceptor> list = new ArrayList<LoadBalancerInterceptor>(restTemplate.getInterceptors());
            if (loadBalancerInterceptor != null) {
                int addIndex = list.size();
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EnhancedRestTemplateInterceptor)) continue;
                    addIndex = i;
                }
                list.add(addIndex, loadBalancerInterceptor);
            }
            restTemplate.setInterceptors(list);
        };
    }
}

