/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.registry.PolarisRegistration;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.assembly.api.AssemblyAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.StringUtils;

public class PolarisAutoServiceRegistration
extends AbstractAutoServiceRegistration<PolarisRegistration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisAutoServiceRegistration.class);
    private final PolarisRegistration registration;
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final AssemblyAPI assemblyAPI;

    public PolarisAutoServiceRegistration(ServiceRegistry<PolarisRegistration> serviceRegistry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, PolarisRegistration registration, PolarisDiscoveryProperties polarisDiscoveryProperties, AssemblyAPI assemblyAPI) {
        super(serviceRegistry, autoServiceRegistrationProperties);
        this.registration = registration;
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.assemblyAPI = assemblyAPI;
    }

    protected PolarisRegistration getRegistration() {
        return this.registration;
    }

    protected PolarisRegistration getManagementRegistration() {
        return null;
    }

    protected void register() {
        if (!this.registration.isRegisterEnabled()) {
            LOGGER.debug("Registration disabled.");
            return;
        }
        if (this.assemblyAPI != null) {
            this.assemblyAPI.initService(new ServiceKey(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE));
        }
        super.register();
    }

    protected void registerManagement() {
        if (!this.registration.isRegisterEnabled()) {
            return;
        }
        super.registerManagement();
    }

    protected void deregister() {
        if (!this.registration.isRegisterEnabled()) {
            return;
        }
        super.deregister();
    }

    protected void deregisterManagement() {
        if (!this.registration.isRegisterEnabled()) {
            return;
        }
        super.deregisterManagement();
    }

    protected Object getConfiguration() {
        return this.polarisDiscoveryProperties;
    }

    protected boolean isEnabled() {
        return this.registration.isRegisterEnabled();
    }

    protected String getAppName() {
        String appName = this.registration.getServiceId();
        return StringUtils.isEmpty((Object)appName) ? super.getAppName() : appName;
    }
}

