/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris;

import com.tencent.cloud.common.constant.ContextConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.polaris.discovery")
public class PolarisDiscoveryProperties {
    @Value(value="${spring.cloud.polaris.discovery.namespace:${spring.cloud.polaris.namespace:#{'default'}}}")
    private String namespace;
    @Value(value="${spring.cloud.polaris.discovery.service:${spring.cloud.polaris.service:${spring.application.name:}}}")
    private String service;
    private String instanceId;
    private String token;
    @Value(value="${spring.cloud.polaris.discovery.weight:#{100}}")
    private int weight;
    private String version = "1.0.0";
    @Value(value="${spring.cloud.polaris.discovery.protocol:http}")
    private String protocol;
    private Boolean enabled = true;
    @Value(value="${spring.cloud.polaris.discovery.register:#{true}}")
    private Boolean registerEnabled;
    private Integer heartbeatInterval = ContextConstant.DEFAULT_REGISTRY_HEARTBEAT_TIME_INTERVAL;
    @Value(value="${spring.cloud.polaris.discovery.health-check-url:}")
    private String healthCheckUrl;
    private Long serviceListRefreshInterval = 60000L;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public Long getServiceListRefreshInterval() {
        return this.serviceListRefreshInterval;
    }

    public void setServiceListRefreshInterval(Long serviceListRefreshInterval) {
        this.serviceListRefreshInterval = serviceListRefreshInterval;
    }

    public Integer getHeartbeatInterval() {
        if (this.heartbeatInterval <= 0 || this.heartbeatInterval > 60) {
            this.heartbeatInterval = ContextConstant.DEFAULT_REGISTRY_HEARTBEAT_TIME_INTERVAL;
        }
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Integer heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public void setRegisterEnabled(Boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String toString() {
        return "PolarisDiscoveryProperties{namespace='" + this.namespace + "', service='" + this.service + "', instanceId='" + this.instanceId + "', token='" + this.token + "', weight=" + this.weight + ", version='" + this.version + "', protocol='" + this.protocol + "', enabled=" + this.enabled + ", registerEnabled=" + this.registerEnabled + ", heartbeatInterval=" + this.heartbeatInterval + ", healthCheckUrl='" + this.healthCheckUrl + "', serviceListRefreshInterval=" + this.serviceListRefreshInterval + "}";
    }
}

