/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.polaris.discovery")
public class PolarisDiscoveryProperties {
    private String token;
    @Value(value="${spring.cloud.polaris.discovery.namespace:${spring.cloud.polaris.namespace:#{'default'}}}")
    private String namespace;
    @Value(value="${spring.cloud.polaris.discovery.service:${spring.cloud.polaris.service:${spring.application.name:}}}")
    private String service;
    @Value(value="${spring.cloud.polaris.discovery.weight:#{100}}")
    private int weight;
    private String version;
    @Value(value="${spring.cloud.polaris.discovery.protocol:http}")
    private String protocol;
    @Value(value="${server.port:}")
    private int port;
    private Boolean enabled = true;
    @Value(value="${spring.cloud.polaris.discovery.register:#{true}}")
    private Boolean registerEnabled;
    @Value(value="${spring.cloud.polaris.discovery.heartbeat.enabled:#{true}}")
    private Boolean heartbeatEnabled = true;
    @Value(value="${spring.cloud.polaris.discovery.health-check-url:}")
    private String healthCheckUrl;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((String)this.getNamespace())) {
            this.setNamespace(this.environment.resolvePlaceholders("${spring.cloud.polaris.discovery.namespace:}"));
        }
        if (StringUtils.isEmpty((String)this.getService())) {
            this.setService(this.environment.resolvePlaceholders("${spring.cloud.polaris.discovery.service:}"));
        }
        if (StringUtils.isEmpty((String)this.getToken())) {
            this.setToken(this.environment.resolvePlaceholders("${spring.cloud.polaris.discovery.token:}"));
        }
    }

    public boolean isHeartbeatEnabled() {
        if (null == this.heartbeatEnabled) {
            return false;
        }
        return this.heartbeatEnabled;
    }

    public void setHeartbeatEnabled(Boolean heartbeatEnabled) {
        this.heartbeatEnabled = heartbeatEnabled;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public String toString() {
        return "PolarisProperties{token='" + this.token + '\'' + ", namespace='" + this.namespace + '\'' + ", service='" + this.service + '\'' + ", weight=" + this.weight + ", version='" + this.version + '\'' + ", protocol='" + this.protocol + '\'' + ", port=" + this.port + '\'' + ", registerEnabled=" + this.registerEnabled + ", heartbeatEnabled=" + this.heartbeatEnabled + ", healthCheckUrl=" + this.healthCheckUrl + ", environment=" + this.environment + '}';
    }

    @Bean
    @ConditionalOnMissingBean
    public PolarisDiscoveryConfigModifier polarisDiscoveryConfigModifier() {
        return new PolarisDiscoveryConfigModifier();
    }

    private static class PolarisDiscoveryConfigModifier
    implements PolarisConfigModifier {
        private final String ID = "polaris";
        @Autowired(required=false)
        private PolarisDiscoveryProperties polarisDiscoveryProperties;

        private PolarisDiscoveryConfigModifier() {
        }

        public void modify(ConfigurationImpl configuration) {
            if (this.polarisDiscoveryProperties != null) {
                DiscoveryConfigImpl discoveryConfig = new DiscoveryConfigImpl();
                discoveryConfig.setServerConnectorId("polaris");
                discoveryConfig.setEnable(this.polarisDiscoveryProperties.enabled);
                configuration.getConsumer().getDiscoveries().add(discoveryConfig);
                RegisterConfigImpl registerConfig = new RegisterConfigImpl();
                registerConfig.setServerConnectorId("polaris");
                registerConfig.setEnable(this.polarisDiscoveryProperties.registerEnabled.booleanValue());
                configuration.getProvider().getRegisters().add(registerConfig);
            }
        }

        public int getOrder() {
            return ContextConstant.ModifierOrder.LAST;
        }
    }
}

