/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.common.constant.MetadataConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolarisDiscoveryHandler {
    @Autowired
    private PolarisDiscoveryProperties polarisDiscoveryProperties;
    @Autowired
    private ProviderAPI providerAPI;
    @Autowired
    private ConsumerAPI polarisConsumer;

    public InstancesResponse getFilteredInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetInstancesRequest getInstancesRequest = new GetInstancesRequest();
        getInstancesRequest.setNamespace(namespace);
        getInstancesRequest.setService(service);
        String method = MetadataContextHolder.get().getSystemMetadata(MetadataConstant.SystemMetadataKey.PEER_PATH);
        getInstancesRequest.setMethod(method);
        String localNamespace = MetadataContext.LOCAL_NAMESPACE;
        String localService = MetadataContext.LOCAL_SERVICE;
        Map allTransitiveCustomMetadata = MetadataContextHolder.get().getAllTransitiveCustomMetadata();
        if (StringUtils.isNotBlank((String)localNamespace) || StringUtils.isNotBlank((String)localService) || null != allTransitiveCustomMetadata) {
            ServiceInfo sourceService = new ServiceInfo();
            sourceService.setNamespace(localNamespace);
            sourceService.setService(localService);
            sourceService.setMetadata(allTransitiveCustomMetadata);
            getInstancesRequest.setServiceInfo((ServiceMetadata)sourceService);
        }
        return this.polarisConsumer.getInstances(getInstancesRequest);
    }

    public InstancesResponse getInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetAllInstancesRequest request = new GetAllInstancesRequest();
        request.setNamespace(namespace);
        request.setService(service);
        return this.polarisConsumer.getAllInstance(request);
    }

    public ProviderAPI getProviderAPI() {
        return this.providerAPI;
    }

    public ServicesResponse GetServices() {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetServicesRequest request = new GetServicesRequest();
        request.setNamespace(namespace);
        return this.polarisConsumer.getServices(request);
    }
}

