/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.InstancesResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;

public class PolarisServiceDiscovery {
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;

    public PolarisServiceDiscovery(PolarisDiscoveryHandler polarisDiscoveryHandler) {
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
    }

    public List<ServiceInstance> getInstances(String serviceId) throws PolarisException {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        InstancesResponse filteredInstances = this.polarisDiscoveryHandler.getFilteredInstances(serviceId);
        ServiceInstances serviceInstances = filteredInstances.toServiceInstances();
        for (Instance instance : serviceInstances.getInstances()) {
            instances.add((ServiceInstance)new PolarisServiceInstance(instance));
        }
        return instances;
    }

    public List<String> getServices() throws PolarisException {
        return this.polarisDiscoveryHandler.GetServices().getServices().stream().map(ServiceInfo::getService).collect(Collectors.toList());
    }
}

