/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.extend.consul;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(value="spring.cloud.consul")
public class ConsulContextProperties {
    private String host;
    private int port;
    private boolean enabled = false;
    @Value(value="${spring.cloud.consul.discovery.register:#{'true'}}")
    private boolean register;
    @Value(value="${spring.cloud.consul.discovery.enabled:#{'true'}}")
    private boolean discoveryEnabled;
    @Value(value="${spring.cloud.consul.discovery.instance-id:}")
    private String instanceId;
    @Value(value="${spring.cloud.consul.discovery.service-name:${spring.application.name:}}")
    private String serviceName;
    @Value(value="${spring.cloud.consul.discovery.ip-address:}")
    private String ipAddress;
    @Value(value="${spring.cloud.consul.discovery.prefer-ip-address:#{'false'}}")
    private boolean preferIpAddress;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRegister() {
        return this.register;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulConfigModifier consulConfigModifier() {
        return new ConsulConfigModifier();
    }

    private static class ConsulConfigModifier
    implements PolarisConfigModifier {
        private final String ID = "consul";
        @Autowired(required=false)
        private ConsulContextProperties consulContextProperties;

        private ConsulConfigModifier() {
        }

        public void modify(ConfigurationImpl configuration) {
            if (this.consulContextProperties != null && this.consulContextProperties.enabled) {
                if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors())) {
                    configuration.getGlobal().setServerConnectors(new ArrayList());
                }
                if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors()) && null != configuration.getGlobal().getServerConnector()) {
                    configuration.getGlobal().getServerConnectors().add(configuration.getGlobal().getServerConnector());
                }
                ServerConnectorConfigImpl serverConnectorConfig = new ServerConnectorConfigImpl();
                serverConnectorConfig.setId("consul");
                serverConnectorConfig.setAddresses(Collections.singletonList(this.consulContextProperties.host + ":" + this.consulContextProperties.port));
                serverConnectorConfig.setProtocol("consul");
                Map metadata = serverConnectorConfig.getMetadata();
                if (StringUtils.isNotBlank((String)this.consulContextProperties.serviceName)) {
                    metadata.put("SERVICE_NAME_KEY", this.consulContextProperties.serviceName);
                }
                if (StringUtils.isNotBlank((String)this.consulContextProperties.instanceId)) {
                    metadata.put("INSTANCE_ID_KEY", this.consulContextProperties.instanceId);
                }
                if (this.consulContextProperties.preferIpAddress && StringUtils.isNotBlank((String)this.consulContextProperties.ipAddress)) {
                    metadata.put("PREFER_IP_ADDRESS_KEY", String.valueOf(this.consulContextProperties.preferIpAddress));
                    metadata.put("IP_ADDRESS_KEY", this.consulContextProperties.ipAddress);
                }
                configuration.getGlobal().getServerConnectors().add(serverConnectorConfig);
                DiscoveryConfigImpl discoveryConfig = new DiscoveryConfigImpl();
                discoveryConfig.setServerConnectorId("consul");
                discoveryConfig.setEnable(Boolean.valueOf(this.consulContextProperties.discoveryEnabled));
                configuration.getConsumer().getDiscoveries().add(discoveryConfig);
                RegisterConfigImpl registerConfig = new RegisterConfigImpl();
                registerConfig.setServerConnectorId("consul");
                registerConfig.setEnable(this.consulContextProperties.register);
                configuration.getProvider().getRegisters().add(registerConfig);
            }
        }

        public int getOrder() {
            return ContextConstant.ModifierOrder.LAST;
        }
    }
}

