/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.polaris.DiscoveryPropertiesAutoConfiguration;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.polaris.client.api.SDKContext;
import java.net.URI;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;

public class PolarisRegistration
implements Registration,
ServiceInstance {
    private final DiscoveryPropertiesAutoConfiguration discoveryPropertiesAutoConfiguration;
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final SDKContext polarisContext;

    public PolarisRegistration(DiscoveryPropertiesAutoConfiguration discoveryPropertiesAutoConfiguration, PolarisDiscoveryProperties polarisDiscoveryProperties, SDKContext context) {
        this.discoveryPropertiesAutoConfiguration = discoveryPropertiesAutoConfiguration;
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisContext = context;
    }

    public String getServiceId() {
        return this.polarisDiscoveryProperties.getService();
    }

    public String getHost() {
        return this.polarisContext.getConfig().getGlobal().getAPI().getBindIP();
    }

    public int getPort() {
        return this.polarisDiscoveryProperties.getPort();
    }

    public void setPort(int port) {
        this.polarisDiscoveryProperties.setPort(port);
    }

    public boolean isSecure() {
        return StringUtils.equalsIgnoreCase((String)this.polarisDiscoveryProperties.getProtocol(), (String)"https");
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return MetadataContextHolder.get().getAllSystemMetadata();
    }

    public PolarisDiscoveryProperties getPolarisProperties() {
        return this.polarisDiscoveryProperties;
    }

    public boolean isRegisterEnabled() {
        return this.discoveryPropertiesAutoConfiguration.isRegisterEnabled();
    }

    public String toString() {
        return "PolarisRegistration{polarisDiscoveryProperties=" + this.polarisDiscoveryProperties + ", polarisContext=" + this.polarisContext + '}';
    }
}

