/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.registry;

import com.tencent.cloud.common.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.cloud.polaris.util.OkHttpUtil;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.client.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PolarisServiceRegistry
implements ServiceRegistry<Registration> {
    private static final Logger log = LoggerFactory.getLogger(PolarisServiceRegistry.class);
    private static final int ttl = 5;
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;
    private final MetadataLocalProperties metadataLocalProperties;
    private final ScheduledExecutorService heartbeatExecutor;

    public PolarisServiceRegistry(PolarisDiscoveryProperties polarisDiscoveryProperties, PolarisDiscoveryHandler polarisDiscoveryHandler, MetadataLocalProperties metadataLocalProperties) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
        this.metadataLocalProperties = metadataLocalProperties;
        this.heartbeatExecutor = polarisDiscoveryProperties.isHeartbeatEnabled() ? Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("spring-cloud-heartbeat")) : null;
    }

    public void register(Registration registration) {
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No service to register for polaris client...");
            return;
        }
        InstanceRegisterRequest instanceRegisterRequest = new InstanceRegisterRequest();
        instanceRegisterRequest.setNamespace(this.polarisDiscoveryProperties.getNamespace());
        instanceRegisterRequest.setService(registration.getServiceId());
        instanceRegisterRequest.setHost(registration.getHost());
        instanceRegisterRequest.setPort(Integer.valueOf(registration.getPort()));
        instanceRegisterRequest.setWeight(Integer.valueOf(this.polarisDiscoveryProperties.getWeight()));
        instanceRegisterRequest.setToken(this.polarisDiscoveryProperties.getToken());
        if (null != this.heartbeatExecutor) {
            instanceRegisterRequest.setTtl(Integer.valueOf(5));
        }
        instanceRegisterRequest.setMetadata(this.metadataLocalProperties.getContent());
        instanceRegisterRequest.setProtocol(this.polarisDiscoveryProperties.getProtocol());
        instanceRegisterRequest.setVersion(this.polarisDiscoveryProperties.getVersion());
        try {
            ProviderAPI providerClient = this.polarisDiscoveryHandler.getProviderAPI();
            providerClient.register(instanceRegisterRequest);
            log.info("polaris registry, {} {} {}:{} {} register finished", new Object[]{this.polarisDiscoveryProperties.getNamespace(), registration.getServiceId(), registration.getHost(), registration.getPort(), this.metadataLocalProperties.getContent()});
            if (null != this.heartbeatExecutor) {
                InstanceHeartbeatRequest heartbeatRequest = new InstanceHeartbeatRequest();
                BeanUtils.copyProperties((Object)instanceRegisterRequest, (Object)heartbeatRequest);
                this.heartbeat(heartbeatRequest);
            }
        }
        catch (Exception e) {
            log.error("polaris registry, {} register failed...{},", new Object[]{registration.getServiceId(), registration, e});
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Registration registration) {
        log.info("De-registering from Polaris Server now...");
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No dom to de-register for polaris client...");
            return;
        }
        InstanceDeregisterRequest deRegisterRequest = new InstanceDeregisterRequest();
        deRegisterRequest.setToken(this.polarisDiscoveryProperties.getToken());
        deRegisterRequest.setNamespace(this.polarisDiscoveryProperties.getNamespace());
        deRegisterRequest.setService(registration.getServiceId());
        deRegisterRequest.setHost(registration.getHost());
        deRegisterRequest.setPort(Integer.valueOf(registration.getPort()));
        try {
            ProviderAPI providerClient = this.polarisDiscoveryHandler.getProviderAPI();
            providerClient.deRegister(deRegisterRequest);
        }
        catch (Exception e) {
            log.error("ERR_POLARIS_DEREGISTER, de-register failed...{},", (Object)registration, (Object)e);
        }
        finally {
            if (null != this.heartbeatExecutor) {
                this.heartbeatExecutor.shutdown();
            }
        }
        log.info("De-registration finished.");
    }

    public void close() {
    }

    public void setStatus(Registration registration, String status) {
    }

    public Object getStatus(Registration registration) {
        String serviceName = registration.getServiceId();
        InstancesResponse instancesResponse = this.polarisDiscoveryHandler.getInstances(serviceName);
        Instance[] instances = instancesResponse.getInstances();
        if (null == instances || instances.length == 0) {
            return null;
        }
        for (Instance instance : instances) {
            if (!instance.getHost().equalsIgnoreCase(registration.getHost()) || instance.getPort() != this.polarisDiscoveryProperties.getPort()) continue;
            return instance.isHealthy() ? "UP" : "DOWN";
        }
        return null;
    }

    public void heartbeat(InstanceHeartbeatRequest heartbeatRequest) {
        this.heartbeatExecutor.scheduleWithFixedDelay(() -> {
            try {
                String healthCheckEndpoint = this.polarisDiscoveryProperties.getHealthCheckUrl();
                if (Strings.isNotEmpty((CharSequence)healthCheckEndpoint)) {
                    String healthCheckUrl;
                    if (!healthCheckEndpoint.startsWith("/")) {
                        healthCheckEndpoint = "/" + healthCheckEndpoint;
                    }
                    if (!OkHttpUtil.get(healthCheckUrl = String.format("http://%s:%s%s", heartbeatRequest.getHost(), heartbeatRequest.getPort(), healthCheckEndpoint), null)) {
                        log.error("backend service health check failed. health check endpoint = {}", (Object)healthCheckEndpoint);
                        return;
                    }
                }
                this.polarisDiscoveryHandler.getProviderAPI().heartbeat(heartbeatRequest);
            }
            catch (PolarisException e) {
                log.error("polaris heartbeat[{}]", (Object)e.getCode(), (Object)e);
            }
            catch (Exception e) {
                log.error("polaris heartbeat runtime error", (Throwable)e);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }
}

