/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import com.tencent.cloud.common.pojo.PolarisServer;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.InstancesResponse;
import java.util.ArrayList;
import java.util.List;

public class PolarisServerList
extends AbstractServerList<Server> {
    private String serviceId;
    private PolarisDiscoveryHandler polarisDiscoveryHandler;

    public PolarisServerList(PolarisDiscoveryHandler polarisDiscoveryHandler) {
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
    }

    public List<Server> getInitialListOfServers() {
        return this.getServers();
    }

    public List<Server> getUpdatedListOfServers() {
        return this.getServers();
    }

    private List<Server> getServers() {
        InstancesResponse allInstances = this.polarisDiscoveryHandler.getFilteredInstances(this.serviceId);
        ServiceInstances serviceInstances = allInstances.toServiceInstances();
        ArrayList<Server> polarisServers = new ArrayList<Server>();
        for (Instance instance : serviceInstances.getInstances()) {
            polarisServers.add((Server)new PolarisServer(serviceInstances, instance));
        }
        return polarisServers;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.serviceId = iClientConfig.getClientName();
    }
}

