/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris;

import com.tencent.cloud.polaris.DiscoveryConfigModifier;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.cloud.polaris.extend.consul.ConsulContextProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisEnabled
@Import(value={PolarisDiscoveryProperties.class, ConsulContextProperties.class})
public class DiscoveryPropertiesAutoConfiguration {
    @Autowired(required=false)
    private PolarisDiscoveryProperties polarisDiscoveryProperties;
    @Autowired(required=false)
    private ConsulContextProperties consulContextProperties;
    private boolean registerEnabled = false;
    private boolean discoveryEnabled = false;

    @Bean
    @ConditionalOnMissingBean
    public ProviderAPI polarisProvider(SDKContext polarisContext) throws PolarisException {
        return DiscoveryAPIFactory.createProviderAPIByContext((SDKContext)polarisContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsumerAPI polarisConsumer(SDKContext polarisContext) throws PolarisException {
        return DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)polarisContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public PolarisDiscoveryHandler polarisDiscoveryHandler() {
        return new PolarisDiscoveryHandler();
    }

    @Bean
    public DiscoveryConfigModifier discoveryConfigModifier() {
        return new DiscoveryConfigModifier();
    }

    @PostConstruct
    public void init() {
        if (null != this.polarisDiscoveryProperties) {
            this.registerEnabled |= this.polarisDiscoveryProperties.isRegisterEnabled();
            this.discoveryEnabled |= this.polarisDiscoveryProperties.isEnabled().booleanValue();
        }
        if (null != this.consulContextProperties && this.consulContextProperties.isEnabled()) {
            this.registerEnabled |= this.consulContextProperties.isRegister();
            this.discoveryEnabled |= this.consulContextProperties.isDiscoveryEnabled();
        }
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }
}

