/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;
import com.tencent.polaris.client.api.SDKContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolarisDiscoveryHandler {
    @Autowired
    private PolarisDiscoveryProperties polarisDiscoveryProperties;
    @Autowired
    private ProviderAPI providerAPI;
    @Autowired
    private SDKContext sdkContext;
    @Autowired
    private ConsumerAPI polarisConsumer;

    public InstancesResponse getHealthyInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetHealthyInstancesRequest getHealthyInstancesRequest = new GetHealthyInstancesRequest();
        getHealthyInstancesRequest.setNamespace(namespace);
        getHealthyInstancesRequest.setService(service);
        return this.polarisConsumer.getHealthyInstancesInstance(getHealthyInstancesRequest);
    }

    public InstancesResponse getInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetAllInstancesRequest request = new GetAllInstancesRequest();
        request.setNamespace(namespace);
        request.setService(service);
        return this.polarisConsumer.getAllInstance(request);
    }

    public ProviderAPI getProviderAPI() {
        return this.providerAPI;
    }

    public SDKContext getSdkContext() {
        return this.sdkContext;
    }

    public ServicesResponse GetServices() {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetServicesRequest request = new GetServicesRequest();
        request.setNamespace(namespace);
        return this.polarisConsumer.getServices(request);
    }
}

