/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery.refresh;

import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.cloud.polaris.discovery.refresh.PolarisServiceStatusChangeListener;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.client.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;

public class PolarisRefreshApplicationReadyEventListener
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationEventPublisherAware {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisRefreshApplicationReadyEventListener.class);
    private static final int DELAY = 60;
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;
    private final PolarisServiceStatusChangeListener polarisServiceStatusChangeListener;
    private final ScheduledExecutorService refreshExecutor;
    private ApplicationEventPublisher publisher;

    public PolarisRefreshApplicationReadyEventListener(PolarisDiscoveryHandler polarisDiscoveryHandler, PolarisServiceStatusChangeListener polarisServiceStatusChangeListener) {
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
        this.polarisServiceStatusChangeListener = polarisServiceStatusChangeListener;
        this.refreshExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("polaris-service-refresh"));
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.polarisDiscoveryHandler.getSdkContext().getExtensions().getLocalRegistry().registerResourceListener((ResourceEventListener)this.polarisServiceStatusChangeListener);
        this.refresh();
    }

    public void refresh() {
        this.refreshExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)PolarisServiceStatusChangeListener.INDEX.getAndIncrement()));
            }
            catch (Exception e) {
                LOG.error("refresh polaris service error.", (Throwable)e);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

