/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.util;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpUtil {
    public static final Logger logger = LoggerFactory.getLogger(OkHttpUtil.class);
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();

    private OkHttpUtil() {
    }

    public static boolean get(String url, Map<String, String> headers) {
        try {
            Request.Builder builder = new Request.Builder();
            OkHttpUtil.buildHeader(builder, headers);
            Request request = builder.url(url).build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            if (response.isSuccessful() && Objects.nonNull(response.body())) {
                String result = response.body().string();
                logger.debug("exec get request, url: {} success\uff0cresponse data: {}", (Object)url, (Object)result);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("exec get request\uff0curl: {} failed!", (Object)url, (Object)e);
        }
        return false;
    }

    private static void buildHeader(Request.Builder builder, Map<String, String> headers) {
        if (Objects.nonNull(headers) && headers.size() > 0) {
            headers.forEach((k, v) -> {
                if (Objects.nonNull(k) && Objects.nonNull(v)) {
                    builder.addHeader(k, v);
                }
            });
        }
    }
}

