/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class PolarisRouterContext {
    private Map<String, Map<String, String>> labels;

    public Map<String, String> getLabels(String labelType) {
        if (CollectionUtils.isEmpty(this.labels)) {
            return Collections.emptyMap();
        }
        Map<String, String> subLabels = this.labels.get(labelType);
        if (CollectionUtils.isEmpty(subLabels)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(subLabels);
    }

    public Map<String, String> getLabels(String labelType, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        Map<String, String> typeLabels = this.getLabels(labelType);
        if (CollectionUtils.isEmpty(typeLabels)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String key : labelKeys) {
            String value = typeLabels.get(key);
            if (!StringUtils.isNotBlank((String)value)) continue;
            labels.put(key, value);
        }
        return labels;
    }

    public String getLabel(String labelKey) {
        Map<String, String> routerLabels = this.labels.get("allMetadata");
        if (CollectionUtils.isEmpty(routerLabels)) {
            return "";
        }
        return routerLabels.get(labelKey);
    }

    public Set<String> getLabelAsSet(String labelKey) {
        Map<String, String> routerLabels = this.labels.get("allMetadata");
        if (CollectionUtils.isEmpty(routerLabels)) {
            return Collections.emptySet();
        }
        for (Map.Entry<String, String> entry : routerLabels.entrySet()) {
            String keysStr;
            if (!StringUtils.equalsIgnoreCase((String)labelKey, (String)entry.getKey()) || !StringUtils.isNotBlank((String)(keysStr = entry.getValue()))) continue;
            String[] keysArr = StringUtils.split((String)keysStr, (String)",");
            return new HashSet<String>(Arrays.asList(keysArr));
        }
        return Collections.emptySet();
    }

    public void putLabels(String labelType, Map<String, String> subLabels) {
        if (this.labels == null) {
            this.labels = new HashMap<String, Map<String, String>>();
        }
        LinkedCaseInsensitiveMap subLabelMap = new LinkedCaseInsensitiveMap();
        if (!CollectionUtils.isEmpty(subLabels)) {
            subLabelMap.putAll(subLabels);
        }
        this.labels.put(labelType, (Map<String, String>)subLabelMap);
    }
}

