/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.polaris.loadbalancer.LoadBalancerUtils;
import com.tencent.cloud.polaris.router.PolarisRouterContext;
import com.tencent.cloud.polaris.router.resttemplate.PolarisLoadBalancerRequest;
import com.tencent.cloud.polaris.router.spi.RouterRequestInterceptor;
import com.tencent.cloud.polaris.router.spi.RouterResponseInterceptor;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.router.api.core.RouterAPI;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import com.tencent.polaris.router.api.rpc.ProcessRoutersResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class PolarisRouterServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private final RouterAPI routerAPI;
    private final List<RouterRequestInterceptor> requestInterceptors;
    private final List<RouterResponseInterceptor> responseInterceptors;

    public PolarisRouterServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, RouterAPI routerAPI, List<RouterRequestInterceptor> requestInterceptors, List<RouterResponseInterceptor> responseInterceptors) {
        super(delegate);
        this.routerAPI = routerAPI;
        this.requestInterceptors = requestInterceptors;
        this.responseInterceptors = responseInterceptors;
    }

    public Flux<List<ServiceInstance>> get() {
        throw new PolarisException(ErrorCode.INTERNAL_ERROR, "Unsupported method.");
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        Flux allServers = (Flux)this.getDelegate().get();
        PolarisRouterContext routerContext = null;
        DefaultRequestContext requestContext = (DefaultRequestContext)request.getContext();
        if (requestContext instanceof RequestDataContext) {
            routerContext = this.buildRouterContext(((RequestDataContext)requestContext).getClientRequest().getHeaders());
        } else if (requestContext.getClientRequest() instanceof PolarisLoadBalancerRequest) {
            routerContext = this.buildRouterContext(((PolarisLoadBalancerRequest)requestContext.getClientRequest()).getRequest().getHeaders());
        }
        if (routerContext == null) {
            return allServers;
        }
        return this.doRouter((Flux<List<ServiceInstance>>)allServers, routerContext);
    }

    PolarisRouterContext buildRouterContext(HttpHeaders headers) {
        List labelHeaderValues = headers.get((Object)"internal-router-label");
        if (CollectionUtils.isEmpty((Collection)labelHeaderValues)) {
            return null;
        }
        PolarisRouterContext routerContext = new PolarisRouterContext();
        routerContext.putLabels("transitiveMetadata", MetadataContextHolder.get().getTransitiveMetadata());
        HashMap<String, String> labelHeaderValuesMap = new HashMap<String, String>();
        try {
            Optional labelHeaderValuesOptional = labelHeaderValues.stream().findFirst();
            if (labelHeaderValuesOptional.isPresent()) {
                String labelHeaderValuesContent = (String)labelHeaderValuesOptional.get();
                labelHeaderValuesMap.putAll(JacksonUtils.deserialize2Map((String)URLDecoder.decode(labelHeaderValuesContent, ContextConstant.UTF_8)));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported charset exception " + ContextConstant.UTF_8);
        }
        routerContext.putLabels("allMetadata", labelHeaderValuesMap);
        return routerContext;
    }

    Flux<List<ServiceInstance>> doRouter(Flux<List<ServiceInstance>> allServers, PolarisRouterContext routerContext) {
        ServiceInstances serviceInstances = LoadBalancerUtils.transferServersToServiceInstances(allServers);
        ProcessRoutersRequest processRoutersRequest = this.buildProcessRoutersRequest(serviceInstances, routerContext);
        this.processRouterRequestInterceptors(processRoutersRequest, routerContext);
        ProcessRoutersResponse processRoutersResponse = this.routerAPI.processRouters(processRoutersRequest);
        this.processRouterResponseInterceptors(routerContext, processRoutersResponse);
        ArrayList<PolarisServiceInstance> filteredInstances = new ArrayList<PolarisServiceInstance>();
        ServiceInstances filteredServiceInstances = processRoutersResponse.getServiceInstances();
        for (Instance instance : filteredServiceInstances.getInstances()) {
            filteredInstances.add(new PolarisServiceInstance(instance));
        }
        return Flux.fromIterable(Collections.singletonList(filteredInstances));
    }

    ProcessRoutersRequest buildProcessRoutersRequest(ServiceInstances serviceInstances, PolarisRouterContext key) {
        ProcessRoutersRequest processRoutersRequest = new ProcessRoutersRequest();
        processRoutersRequest.setDstInstances(serviceInstances);
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setNamespace(MetadataContext.LOCAL_NAMESPACE);
        serviceInfo.setService(MetadataContext.LOCAL_SERVICE);
        processRoutersRequest.setSourceService(serviceInfo);
        return processRoutersRequest;
    }

    void processRouterRequestInterceptors(ProcessRoutersRequest processRoutersRequest, PolarisRouterContext routerContext) {
        for (RouterRequestInterceptor requestInterceptor : this.requestInterceptors) {
            requestInterceptor.apply(processRoutersRequest, routerContext);
        }
    }

    private void processRouterResponseInterceptors(PolarisRouterContext routerContext, ProcessRoutersResponse processRoutersResponse) {
        if (!CollectionUtils.isEmpty(this.responseInterceptors)) {
            for (RouterResponseInterceptor responseInterceptor : this.responseInterceptors) {
                responseInterceptor.apply(processRoutersResponse, routerContext);
            }
        }
    }
}

