/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router;

import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.polaris.client.pb.RoutingProto;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class RouterRuleLabelResolver {
    private final ServiceRuleManager serviceRuleManager;

    public RouterRuleLabelResolver(ServiceRuleManager serviceRuleManager) {
        this.serviceRuleManager = serviceRuleManager;
    }

    public Set<String> getExpressionLabelKeys(String namespace, String sourceService, String dstService) {
        List rules = this.serviceRuleManager.getServiceRouterRule(namespace, sourceService, dstService);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return Collections.emptySet();
        }
        HashSet<String> expressionLabels = new HashSet<String>();
        for (RoutingProto.Route rule : rules) {
            List sources = rule.getSourcesList();
            if (CollectionUtils.isEmpty((Collection)sources)) continue;
            for (RoutingProto.Source source : sources) {
                Map labels = source.getMetadataMap();
                if (CollectionUtils.isEmpty((Map)labels)) continue;
                for (String labelKey : labels.keySet()) {
                    if (!ExpressionLabelUtils.isExpressionLabel((String)labelKey)) continue;
                    expressionLabels.add(labelKey);
                }
            }
        }
        return expressionLabels;
    }
}

