/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.config;

import com.tencent.cloud.polaris.router.PolarisRouterServiceInstanceListSupplier;
import com.tencent.cloud.polaris.router.config.ConditionalOnPolarisRouterEnabled;
import com.tencent.cloud.polaris.router.spi.RouterRequestInterceptor;
import com.tencent.cloud.polaris.router.spi.RouterResponseInterceptor;
import com.tencent.polaris.router.api.core.RouterAPI;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisRouterEnabled
@ConditionalOnDiscoveryEnabled
public class LoadBalancerConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    protected static class PolarisBlockingSupportConfiguration {
        protected PolarisBlockingSupportConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context, RouterAPI routerAPI, List<RouterRequestInterceptor> requestInterceptors, List<RouterResponseInterceptor> responseInterceptors) {
            return new PolarisRouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().build(context), routerAPI, requestInterceptors, responseInterceptors);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    protected static class PolarisReactiveSupportConfiguration {
        protected PolarisReactiveSupportConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context, RouterAPI routerAPI, List<RouterRequestInterceptor> requestInterceptors, List<RouterResponseInterceptor> responseInterceptors) {
            return new PolarisRouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().build(context), routerAPI, requestInterceptors, responseInterceptors);
        }
    }
}

