/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.config;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.router.RouterRuleLabelResolver;
import com.tencent.cloud.polaris.router.beanprocessor.ReactiveLoadBalancerClientFilterBeanPostProcessor;
import com.tencent.cloud.polaris.router.config.ConditionalOnPolarisRouterEnabled;
import com.tencent.cloud.polaris.router.config.LoadBalancerConfiguration;
import com.tencent.cloud.polaris.router.config.properties.PolarisMetadataRouterProperties;
import com.tencent.cloud.polaris.router.config.properties.PolarisNearByRouterProperties;
import com.tencent.cloud.polaris.router.config.properties.PolarisRuleBasedRouterProperties;
import com.tencent.cloud.polaris.router.interceptor.MetadataRouterRequestInterceptor;
import com.tencent.cloud.polaris.router.interceptor.NearbyRouterRequestInterceptor;
import com.tencent.cloud.polaris.router.interceptor.RuleBasedRouterRequestInterceptor;
import com.tencent.cloud.polaris.router.resttemplate.RouterLabelRestTemplateInterceptor;
import com.tencent.cloud.polaris.router.spi.SpringWebRouterLabelResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisRouterEnabled
@LoadBalancerClients(defaultConfiguration={LoadBalancerConfiguration.class})
@Import(value={PolarisNearByRouterProperties.class, PolarisMetadataRouterProperties.class, PolarisRuleBasedRouterProperties.class})
public class RouterAutoConfiguration {
    @Bean
    @Order(value=-2147483648)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter"})
    public ReactiveLoadBalancerClientFilterBeanPostProcessor loadBalancerClientFilterBeanPostProcessor() {
        return new ReactiveLoadBalancerClientFilterBeanPostProcessor();
    }

    @Bean
    public RouterRuleLabelResolver routerRuleLabelResolver(ServiceRuleManager serviceRuleManager) {
        return new RouterRuleLabelResolver(serviceRuleManager);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.polaris.router.metadata-router.enabled"}, matchIfMissing=true)
    public MetadataRouterRequestInterceptor metadataRouterRequestInterceptor(PolarisMetadataRouterProperties polarisMetadataRouterProperties) {
        return new MetadataRouterRequestInterceptor(polarisMetadataRouterProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.polaris.router.nearby-router.enabled"}, matchIfMissing=true)
    public NearbyRouterRequestInterceptor nearbyRouterRequestInterceptor(PolarisNearByRouterProperties polarisNearByRouterProperties) {
        return new NearbyRouterRequestInterceptor(polarisNearByRouterProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.polaris.router.rule-router.enabled"}, matchIfMissing=true)
    public RuleBasedRouterRequestInterceptor ruleBasedRouterRequestInterceptor(PolarisRuleBasedRouterProperties polarisRuleBasedRouterProperties) {
        return new RuleBasedRouterRequestInterceptor(polarisRuleBasedRouterProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    @ConditionalOnProperty(value={"spring.cloud.polaris.router.rule-router.enabled"}, matchIfMissing=true)
    protected static class RouterLabelRestTemplateConfig {
        @Autowired(required=false)
        private List<RestTemplate> restTemplates = Collections.emptyList();

        protected RouterLabelRestTemplateConfig() {
        }

        @Bean
        public RouterLabelRestTemplateInterceptor routerLabelRestTemplateInterceptor(List<SpringWebRouterLabelResolver> routerLabelResolvers, StaticMetadataManager staticMetadataManager, RouterRuleLabelResolver routerRuleLabelResolver, PolarisContextProperties polarisContextProperties) {
            return new RouterLabelRestTemplateInterceptor(routerLabelResolvers, staticMetadataManager, routerRuleLabelResolver, polarisContextProperties);
        }

        @Bean
        public SmartInitializingSingleton addRouterLabelInterceptorForRestTemplate(RouterLabelRestTemplateInterceptor interceptor) {
            return () -> this.restTemplates.forEach(restTemplate -> {
                ArrayList<RouterLabelRestTemplateInterceptor> list = new ArrayList<RouterLabelRestTemplateInterceptor>(restTemplate.getInterceptors());
                list.add(interceptor);
                restTemplate.setInterceptors(list);
            });
        }
    }
}

