/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.endpoint;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.polaris.client.pb.RoutingProto;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.util.CollectionUtils;

@Endpoint(id="polaris-router")
public class PolarisRouterEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisRouterEndpoint.class);
    private final ServiceRuleManager serviceRuleManager;

    public PolarisRouterEndpoint(ServiceRuleManager serviceRuleManager) {
        this.serviceRuleManager = serviceRuleManager;
    }

    @ReadOperation
    public Map<String, Object> router(@Selector String dstService) {
        List routerRules = this.serviceRuleManager.getServiceRouterRule(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE, dstService);
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<Object> rules = new LinkedList<Object>();
        result.put("routerRules", rules);
        if (CollectionUtils.isEmpty((Collection)routerRules)) {
            return result;
        }
        for (RoutingProto.Route route : routerRules) {
            rules.add(this.parseRouterRule(route));
        }
        return result;
    }

    private Object parseRouterRule(RoutingProto.Route routeRule) {
        HashMap result = new HashMap();
        List sourcePbs = routeRule.getSourcesList();
        LinkedList<Object> sources = new LinkedList<Object>();
        for (RoutingProto.Source sourcePb : sourcePbs) {
            sources.add(this.pb2Json((MessageOrBuilder)sourcePb));
        }
        result.put("sources", sources);
        List destPbs = routeRule.getDestinationsList();
        LinkedList<Object> destinations = new LinkedList<Object>();
        for (RoutingProto.Destination destPb : destPbs) {
            destinations.add(this.pb2Json((MessageOrBuilder)destPb));
        }
        result.put("destinations", destinations);
        return result;
    }

    private Object pb2Json(MessageOrBuilder pbObject) {
        String jsonStr;
        try {
            jsonStr = JsonFormat.printer().print(pbObject);
        }
        catch (InvalidProtocolBufferException e) {
            String msg = "parse router rule to json error.";
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return JacksonUtils.deserialize2Map((String)jsonStr);
    }
}

