/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.feign;

import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import feign.RequestTemplate;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public final class FeignExpressionLabelUtils {
    private FeignExpressionLabelUtils() {
    }

    public static Map<String, String> resolve(RequestTemplate request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (ExpressionLabelUtils.isHeaderLabel((String)labelKey)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey((String)labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, FeignExpressionLabelUtils.getHeaderValue(request, headerKey));
                continue;
            }
            if (ExpressionLabelUtils.isQueryLabel((String)labelKey)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey((String)labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, FeignExpressionLabelUtils.getQueryValue(request, queryKey));
                continue;
            }
            if (ExpressionLabelUtils.isMethodLabel((String)labelKey)) {
                labels.put(labelKey, request.method());
                continue;
            }
            if (!ExpressionLabelUtils.isUriLabel((String)labelKey)) continue;
            URI uri = URI.create(request.request().url());
            labels.put(labelKey, uri.getPath());
        }
        return labels;
    }

    public static String getHeaderValue(RequestTemplate request, String key) {
        Map headers = request.headers();
        return ExpressionLabelUtils.getFirstValue((Map)headers, (String)key);
    }

    public static String getQueryValue(RequestTemplate request, String key) {
        return ExpressionLabelUtils.getFirstValue((Map)request.queries(), (String)key);
    }
}

