/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.feign;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.router.RouterRuleLabelResolver;
import com.tencent.cloud.polaris.router.feign.FeignExpressionLabelUtils;
import com.tencent.cloud.polaris.router.spi.FeignRouterLabelResolver;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class RouterLabelFeignInterceptor
implements RequestInterceptor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterLabelFeignInterceptor.class);
    private final List<FeignRouterLabelResolver> routerLabelResolvers;
    private final StaticMetadataManager staticMetadataManager;
    private final RouterRuleLabelResolver routerRuleLabelResolver;
    private final PolarisContextProperties polarisContextProperties;

    public RouterLabelFeignInterceptor(List<FeignRouterLabelResolver> routerLabelResolvers, StaticMetadataManager staticMetadataManager, RouterRuleLabelResolver routerRuleLabelResolver, PolarisContextProperties polarisContextProperties) {
        if (!CollectionUtils.isEmpty(routerLabelResolvers)) {
            routerLabelResolvers.sort(Comparator.comparingInt(Ordered::getOrder));
            this.routerLabelResolvers = routerLabelResolvers;
        } else {
            this.routerLabelResolvers = null;
        }
        this.staticMetadataManager = staticMetadataManager;
        this.routerRuleLabelResolver = routerRuleLabelResolver;
        this.polarisContextProperties = polarisContextProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void apply(RequestTemplate requestTemplate) {
        String encodedLabelsContent;
        HashMap<String, String> labels = new HashMap<String, String>(this.staticMetadataManager.getMergedStaticMetadata());
        String peerServiceName = requestTemplate.feignTarget().name();
        Set<String> expressionLabelKeys = this.routerRuleLabelResolver.getExpressionLabelKeys(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE, peerServiceName);
        Map<String, String> ruleExpressionLabels = this.getRuleExpressionLabels(requestTemplate, expressionLabelKeys);
        labels.putAll(ruleExpressionLabels);
        if (!CollectionUtils.isEmpty(this.routerLabelResolvers)) {
            this.routerLabelResolvers.forEach(resolver -> {
                try {
                    Map<String, String> customResolvedLabels = resolver.resolve(requestTemplate, expressionLabelKeys);
                    if (!CollectionUtils.isEmpty(customResolvedLabels)) {
                        labels.putAll(customResolvedLabels);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("[SCT][Router] revoke RouterLabelResolver occur some exception. ", t);
                }
            });
        }
        Map transitiveLabels = MetadataContextHolder.get().getTransitiveMetadata();
        labels.putAll(transitiveLabels);
        try {
            encodedLabelsContent = URLEncoder.encode(JacksonUtils.serialize2Json(labels), ContextConstant.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported charset exception " + ContextConstant.UTF_8);
        }
        requestTemplate.header("internal-router-label", new String[]{encodedLabelsContent});
    }

    private Map<String, String> getRuleExpressionLabels(RequestTemplate requestTemplate, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        Map<String, String> labels = FeignExpressionLabelUtils.resolve(requestTemplate, labelKeys);
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isCallerIPLabel((String)labelKey)) continue;
            labels.put(labelKey, this.polarisContextProperties.getLocalIpAddress());
        }
        return labels;
    }
}

