/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.interceptor;

import com.tencent.cloud.polaris.router.PolarisRouterContext;
import com.tencent.cloud.polaris.router.config.properties.PolarisMetadataRouterProperties;
import com.tencent.cloud.polaris.router.spi.RouterRequestInterceptor;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import java.util.Map;
import java.util.Set;

public class MetadataRouterRequestInterceptor
implements RouterRequestInterceptor {
    private static final String LABEL_KEY_METADATA_ROUTER_KEYS = "system-metadata-router-keys";
    private final PolarisMetadataRouterProperties polarisMetadataRouterProperties;

    public MetadataRouterRequestInterceptor(PolarisMetadataRouterProperties polarisMetadataRouterProperties) {
        this.polarisMetadataRouterProperties = polarisMetadataRouterProperties;
    }

    @Override
    public void apply(ProcessRoutersRequest request, PolarisRouterContext routerContext) {
        if (!this.polarisMetadataRouterProperties.isEnabled()) {
            return;
        }
        Set<String> metadataRouterKeys = routerContext.getLabelAsSet(LABEL_KEY_METADATA_ROUTER_KEYS);
        Map<String, String> metadataRouterLabels = routerContext.getLabels("allMetadata", metadataRouterKeys);
        request.addRouterMetadata("metadataRoute", metadataRouterLabels);
    }
}

