/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.interceptor;

import com.tencent.cloud.polaris.router.PolarisRouterContext;
import com.tencent.cloud.polaris.router.config.properties.PolarisRuleBasedRouterProperties;
import com.tencent.cloud.polaris.router.spi.RouterRequestInterceptor;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import java.util.HashMap;
import java.util.Map;

public class RuleBasedRouterRequestInterceptor
implements RouterRequestInterceptor {
    private final PolarisRuleBasedRouterProperties polarisRuleBasedRouterProperties;

    public RuleBasedRouterRequestInterceptor(PolarisRuleBasedRouterProperties polarisRuleBasedRouterProperties) {
        this.polarisRuleBasedRouterProperties = polarisRuleBasedRouterProperties;
    }

    @Override
    public void apply(ProcessRoutersRequest request, PolarisRouterContext routerContext) {
        boolean ruleBasedRouterEnabled = this.polarisRuleBasedRouterProperties.isEnabled();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("enabled", String.valueOf(ruleBasedRouterEnabled));
        request.addRouterMetadata("ruleRouter", metadata);
        if (ruleBasedRouterEnabled) {
            Map<String, String> ruleRouterLabels = routerContext.getLabels("allMetadata");
            request.getSourceService().setMetadata(ruleRouterLabels);
        }
    }
}

