/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.resttemplate;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import com.tencent.cloud.common.util.expresstion.SpringWebExpressionLabelUtils;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.router.RouterRuleLabelResolver;
import com.tencent.cloud.polaris.router.spi.SpringWebRouterLabelResolver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RouterLabelRestTemplateInterceptor
implements ClientHttpRequestInterceptor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterLabelRestTemplateInterceptor.class);
    private final List<SpringWebRouterLabelResolver> routerLabelResolvers;
    private final StaticMetadataManager staticMetadataManager;
    private final RouterRuleLabelResolver routerRuleLabelResolver;
    private final PolarisContextProperties polarisContextProperties;

    public RouterLabelRestTemplateInterceptor(List<SpringWebRouterLabelResolver> routerLabelResolvers, StaticMetadataManager staticMetadataManager, RouterRuleLabelResolver routerRuleLabelResolver, PolarisContextProperties polarisContextProperties) {
        this.staticMetadataManager = staticMetadataManager;
        this.routerRuleLabelResolver = routerRuleLabelResolver;
        this.polarisContextProperties = polarisContextProperties;
        if (!CollectionUtils.isEmpty(routerLabelResolvers)) {
            routerLabelResolvers.sort(Comparator.comparingInt(Ordered::getOrder));
            this.routerLabelResolvers = routerLabelResolvers;
        } else {
            this.routerLabelResolvers = null;
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public ClientHttpResponse intercept(@NonNull HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        URI originalUri = request.getURI();
        String peerServiceName = originalUri.getHost();
        Assert.state((peerServiceName != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        this.setLabelsToHeaders(request, body, peerServiceName);
        ClientHttpResponse response = clientHttpRequestExecution.execute(request, body);
        if (!CollectionUtils.isEmpty((Collection)request.getHeaders().get((Object)"internal-router-label"))) {
            response.getHeaders().addAll("internal-router-label", Objects.requireNonNull(request.getHeaders().get((Object)"internal-router-label")));
        }
        return response;
    }

    void setLabelsToHeaders(HttpRequest request, byte[] body, String peerServiceName) {
        String encodedLabelsContent;
        HashMap<String, String> labels = new HashMap<String, String>(this.staticMetadataManager.getMergedStaticMetadata());
        Set<String> expressionLabelKeys = this.routerRuleLabelResolver.getExpressionLabelKeys(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE, peerServiceName);
        Map<String, String> ruleExpressionLabels = this.getExpressionLabels(request, expressionLabelKeys);
        if (!CollectionUtils.isEmpty(ruleExpressionLabels)) {
            labels.putAll(ruleExpressionLabels);
        }
        if (!CollectionUtils.isEmpty(this.routerLabelResolvers)) {
            this.routerLabelResolvers.forEach(resolver -> {
                try {
                    Map<String, String> customResolvedLabels = resolver.resolve(request, body, expressionLabelKeys);
                    if (!CollectionUtils.isEmpty(customResolvedLabels)) {
                        labels.putAll(customResolvedLabels);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("[SCT][Router] revoke RouterLabelResolver occur some exception. ", t);
                }
            });
        }
        Map transitiveLabels = MetadataContextHolder.get().getTransitiveMetadata();
        labels.putAll(transitiveLabels);
        try {
            encodedLabelsContent = URLEncoder.encode(JacksonUtils.serialize2Json(labels), ContextConstant.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported charset exception " + ContextConstant.UTF_8);
        }
        request.getHeaders().set("internal-router-label", encodedLabelsContent);
    }

    private Map<String, String> getExpressionLabels(HttpRequest request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        Map labels = SpringWebExpressionLabelUtils.resolve((HttpRequest)request, labelKeys);
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isCallerIPLabel((String)labelKey)) continue;
            labels.put(labelKey, this.polarisContextProperties.getLocalIpAddress());
        }
        return labels;
    }
}

