/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.router.scg;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import com.tencent.cloud.common.util.expresstion.SpringWebExpressionLabelUtils;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.cloud.polaris.router.RouterRuleLabelResolver;
import com.tencent.cloud.polaris.router.spi.SpringWebRouterLabelResolver;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.gateway.config.GatewayLoadBalancerProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.ReactiveLoadBalancerClientFilter;
import org.springframework.cloud.gateway.support.DelegatingServiceInstance;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class PolarisReactiveLoadBalancerClientFilter
extends ReactiveLoadBalancerClientFilter {
    private static final Logger log = LoggerFactory.getLogger(PolarisReactiveLoadBalancerClientFilter.class);
    private final LoadBalancerClientFactory clientFactory;
    private final GatewayLoadBalancerProperties gatewayLoadBalancerProperties;
    private final LoadBalancerProperties loadBalancerProperties;
    private final StaticMetadataManager staticMetadataManager;
    private final RouterRuleLabelResolver routerRuleLabelResolver;
    private final List<SpringWebRouterLabelResolver> routerLabelResolvers;
    private final PolarisContextProperties polarisContextProperties;

    public PolarisReactiveLoadBalancerClientFilter(LoadBalancerClientFactory clientFactory, GatewayLoadBalancerProperties gatewayLoadBalancerProperties, LoadBalancerProperties loadBalancerProperties, StaticMetadataManager staticMetadataManager, RouterRuleLabelResolver routerRuleLabelResolver, List<SpringWebRouterLabelResolver> routerLabelResolvers, PolarisContextProperties polarisContextProperties) {
        super(clientFactory, gatewayLoadBalancerProperties, loadBalancerProperties);
        this.clientFactory = clientFactory;
        this.gatewayLoadBalancerProperties = gatewayLoadBalancerProperties;
        this.loadBalancerProperties = loadBalancerProperties;
        this.staticMetadataManager = staticMetadataManager;
        this.routerRuleLabelResolver = routerRuleLabelResolver;
        this.routerLabelResolvers = routerLabelResolvers;
        this.polarisContextProperties = polarisContextProperties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI url = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String schemePrefix = (String)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR);
        if (url == null || !"lb".equals(url.getScheme()) && !"lb".equals(schemePrefix)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.addOriginalRequestUrl((ServerWebExchange)exchange, (URI)url);
        if (log.isTraceEnabled()) {
            log.trace(ReactiveLoadBalancerClientFilter.class.getSimpleName() + " url before: " + url);
        }
        URI requestUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String serviceId = requestUri.getHost();
        Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.clientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), RequestDataContext.class, ResponseData.class, ServiceInstance.class);
        HttpHeaders routerHttpHeaders = this.genRouterHttpHeaders(exchange, serviceId);
        ServerHttpRequest request = exchange.getRequest();
        RequestData requestData = new RequestData(request.getMethod(), request.getURI(), routerHttpHeaders, (MultiValueMap)new HttpHeaders(), new HashMap());
        DefaultRequest lbRequest = new DefaultRequest((Object)new RequestDataContext(requestData, this.getHint(serviceId, this.loadBalancerProperties.getHint())));
        return this.choose((Request<RequestDataContext>)lbRequest, serviceId, supportedLifecycleProcessors).doOnNext(response -> {
            String overrideScheme;
            if (!response.hasServer()) {
                supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Request)lbRequest, response)));
                throw NotFoundException.create((boolean)this.gatewayLoadBalancerProperties.isUse404(), (String)("Unable to find instance for " + url.getHost()));
            }
            ServiceInstance retrievedInstance = (ServiceInstance)response.getServer();
            URI uri = exchange.getRequest().getURI();
            String string = overrideScheme = retrievedInstance.isSecure() ? "https" : "http";
            if (schemePrefix != null) {
                overrideScheme = url.getScheme();
            }
            DelegatingServiceInstance serviceInstance = new DelegatingServiceInstance(retrievedInstance, overrideScheme);
            URI requestUrl = this.reconstructURI((ServiceInstance)serviceInstance, uri);
            if (log.isTraceEnabled()) {
                log.trace("LoadBalancerClientFilter url chosen: " + requestUrl);
            }
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR, response);
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStartRequest((Request)lbRequest, response));
        }).then(chain.filter(exchange)).doOnError(throwable -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, throwable, (Request)lbRequest, (Response)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR))))).doOnSuccess(aVoid -> supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, (Request)lbRequest, (Response)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR), (Object)new ResponseData(exchange.getResponse(), new RequestData(exchange.getRequest()))))));
    }

    protected URI reconstructURI(ServiceInstance serviceInstance, URI original) {
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
    }

    private Mono<Response<ServiceInstance>> choose(Request<RequestDataContext> lbRequest, String serviceId, Set<LoadBalancerLifecycle> supportedLifecycleProcessors) {
        ReactorLoadBalancer loadBalancer = (ReactorLoadBalancer)this.clientFactory.getInstance(serviceId, ReactorServiceInstanceLoadBalancer.class);
        if (loadBalancer == null) {
            throw new NotFoundException("No loadbalancer available for " + serviceId);
        }
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart(lbRequest));
        return loadBalancer.choose(lbRequest);
    }

    private String getHint(String serviceId, Map<String, String> hints) {
        String defaultHint = hints.getOrDefault("default", "default");
        String hintPropertyValue = hints.get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    HttpHeaders genRouterHttpHeaders(ServerWebExchange exchange, String peerServiceName) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("internal-router-label", this.genRouterHint(exchange, peerServiceName));
        return headers;
    }

    private String genRouterHint(ServerWebExchange exchange, String peerServiceName) {
        String encodedLabelsContent;
        Map<String, String> routerLabels = this.genRouterLabels(exchange, peerServiceName);
        try {
            encodedLabelsContent = URLEncoder.encode(JacksonUtils.serialize2Json(routerLabels), ContextConstant.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported charset exception " + ContextConstant.UTF_8);
        }
        return encodedLabelsContent;
    }

    private Map<String, String> genRouterLabels(ServerWebExchange exchange, String peerServiceName) {
        HashMap<String, String> labels = new HashMap<String, String>(this.staticMetadataManager.getMergedStaticMetadata());
        Set<String> expressionLabelKeys = this.routerRuleLabelResolver.getExpressionLabelKeys(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE, peerServiceName);
        Map<String, String> ruleExpressionLabels = this.getExpressionLabels(exchange, expressionLabelKeys);
        if (!CollectionUtils.isEmpty(ruleExpressionLabels)) {
            labels.putAll(ruleExpressionLabels);
        }
        if (!CollectionUtils.isEmpty(this.routerLabelResolvers)) {
            this.routerLabelResolvers.forEach(resolver -> {
                try {
                    Map<String, String> customResolvedLabels = resolver.resolve(exchange, expressionLabelKeys);
                    if (!CollectionUtils.isEmpty(customResolvedLabels)) {
                        labels.putAll(customResolvedLabels);
                    }
                }
                catch (Throwable t) {
                    log.error("[SCT][Router] revoke RouterLabelResolver occur some exception. ", t);
                }
            });
        }
        Map transitiveLabels = MetadataContextHolder.get().getTransitiveMetadata();
        labels.putAll(transitiveLabels);
        return labels;
    }

    private Map<String, String> getExpressionLabels(ServerWebExchange exchange, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        Map labels = SpringWebExpressionLabelUtils.resolve((ServerWebExchange)exchange, labelKeys);
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isCallerIPLabel((String)labelKey)) continue;
            labels.put(labelKey, this.polarisContextProperties.getLocalIpAddress());
        }
        return labels;
    }
}

