/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.constant;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SdkVersion {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String SDK_VERSION_KEY = "SCT_SDK_VERSION";
    private static String version;

    private SdkVersion() {
    }

    public static String get() {
        if (version != null) {
            LOG.info("SDK SDK Version: {}", (Object)version);
            return version;
        }
        try {
            Enumeration<URL> resources = SdkVersion.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String name;
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attrs = manifest.getMainAttributes();
                if (attrs == null || !SDK_VERSION_KEY.equals(name = attrs.getValue("Bundle-Name"))) continue;
                String version = attrs.getValue("Bundle-Version");
                LOG.info("SCT SDK Version: {}", (Object)version);
                SdkVersion.version = version;
                break;
            }
            return version;
        }
        catch (Exception exception) {
            LOG.info("could not get bundle : '{}' version, please check MANIFEST.MF format. return default version: UNKNOWN", (Object)SDK_VERSION_KEY);
            return "UNKNOWN";
        }
    }
}

