/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import com.tencent.cloud.common.util.DiscoveryUtil;
import com.tencent.cloud.common.util.JacksonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MetadataContext {
    public static final String FRAGMENT_TRANSITIVE = "transitive";
    public static final String FRAGMENT_DISPOSABLE = "disposable";
    public static final String FRAGMENT_UPSTREAM_DISPOSABLE = "upstream-disposable";
    public static final String FRAGMENT_RAW_TRANSHEADERS = "trans-headers";
    public static final String FRAGMENT_RAW_TRANSHEADERS_KV = "trans-headers-kv";
    private static final Logger LOG = LoggerFactory.getLogger(MetadataContext.class);
    public static String LOCAL_NAMESPACE;
    public static String LOCAL_SERVICE;
    private final Map<String, Map<String, String>> fragmentContexts = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Object> loadbalancerMetadata = new ConcurrentHashMap<String, Object>();

    public Map<String, String> getDisposableMetadata() {
        return this.getFragmentContext(FRAGMENT_DISPOSABLE);
    }

    public Map<String, String> getTransitiveMetadata() {
        return this.getFragmentContext(FRAGMENT_TRANSITIVE);
    }

    public Map<String, String> getCustomMetadata() {
        Map<String, String> transitiveMetadata = this.getTransitiveMetadata();
        Map<String, String> disposableMetadata = this.getDisposableMetadata();
        HashMap customMetadata = new HashMap();
        transitiveMetadata.forEach((key, value) -> {
            if (!disposableMetadata.containsKey(key)) {
                customMetadata.put(key, value);
            }
        });
        return Collections.unmodifiableMap(customMetadata);
    }

    public Map<String, String> getTransHeaders() {
        return this.getFragmentContext(FRAGMENT_RAW_TRANSHEADERS);
    }

    public Map<String, String> getTransHeadersKV() {
        return this.getFragmentContext(FRAGMENT_RAW_TRANSHEADERS_KV);
    }

    public Map<String, Object> getLoadbalancerMetadata() {
        return this.loadbalancerMetadata;
    }

    public void setTransitiveMetadata(Map<String, String> transitiveMetadata) {
        this.putFragmentContext(FRAGMENT_TRANSITIVE, Collections.unmodifiableMap(transitiveMetadata));
    }

    public void setDisposableMetadata(Map<String, String> disposableMetadata) {
        this.putFragmentContext(FRAGMENT_DISPOSABLE, Collections.unmodifiableMap(disposableMetadata));
    }

    public void setUpstreamDisposableMetadata(Map<String, String> upstreamDisposableMetadata) {
        this.putFragmentContext(FRAGMENT_UPSTREAM_DISPOSABLE, Collections.unmodifiableMap(upstreamDisposableMetadata));
    }

    public void setTransHeadersKV(String key, String value) {
        this.putContext(FRAGMENT_RAW_TRANSHEADERS_KV, key, value);
    }

    public void setTransHeaders(String key, String value) {
        this.putContext(FRAGMENT_RAW_TRANSHEADERS, key, value);
    }

    public void setLoadbalancer(String key, Object value) {
        this.loadbalancerMetadata.put(key, value);
    }

    public Map<String, String> getFragmentContext(String fragment) {
        Map<String, String> fragmentContext = this.fragmentContexts.get(fragment);
        if (fragmentContext == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(fragmentContext);
    }

    public String getContext(String fragment, String key) {
        Map<String, String> fragmentContext = this.fragmentContexts.get(fragment);
        if (fragmentContext == null) {
            return null;
        }
        return fragmentContext.get(key);
    }

    public void putContext(String fragment, String key, String value) {
        Map<String, String> fragmentContext = this.fragmentContexts.get(fragment);
        if (fragmentContext == null) {
            fragmentContext = new ConcurrentHashMap<String, String>();
            this.fragmentContexts.put(fragment, fragmentContext);
        }
        fragmentContext.put(key, value);
    }

    public void putFragmentContext(String fragment, Map<String, String> context) {
        this.fragmentContexts.put(fragment, context);
    }

    public String toString() {
        return "MetadataContext{fragmentContexts=" + JacksonUtils.serialize2Json(this.fragmentContexts) + '}';
    }

    static {
        String namespace = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.namespace");
        if (!StringUtils.hasText((String)namespace)) {
            namespace = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.discovery.namespace", "default");
        }
        if (!StringUtils.hasText((String)namespace)) {
            LOG.error("namespace should not be blank. please configure spring.cloud.polaris.namespace or spring.cloud.polaris.discovery.namespace");
            throw new RuntimeException("namespace should not be blank. please configure spring.cloud.polaris.namespace or spring.cloud.polaris.discovery.namespace");
        }
        LOCAL_NAMESPACE = namespace;
        String serviceName = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.service");
        if (!StringUtils.hasText((String)serviceName)) {
            serviceName = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.discovery.service", ApplicationContextAwareUtils.getProperties("spring.application.name", null));
        }
        if (!StringUtils.hasText((String)serviceName)) {
            LOG.error("service name should not be blank. please configure spring.cloud.polaris.service or spring.cloud.polaris.discovery.service or spring.application.name");
            throw new RuntimeException("service name should not be blank. please configure spring.cloud.polaris.service or spring.cloud.polaris.discovery.service or spring.application.name");
        }
        LOCAL_SERVICE = serviceName = DiscoveryUtil.rewriteServiceId(serviceName);
    }
}

