/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.StaticMetadataManager;
import com.tencent.cloud.common.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class MetadataContextHolder {
    private static final ThreadLocal<MetadataContext> METADATA_CONTEXT = new InheritableThreadLocal<MetadataContext>();
    private static MetadataLocalProperties metadataLocalProperties;
    private static StaticMetadataManager staticMetadataManager;

    private MetadataContextHolder() {
    }

    public static MetadataContext get() {
        if (METADATA_CONTEXT.get() != null) {
            return METADATA_CONTEXT.get();
        }
        if (metadataLocalProperties == null) {
            metadataLocalProperties = (MetadataLocalProperties)ApplicationContextAwareUtils.getApplicationContext().getBean(MetadataLocalProperties.class);
        }
        if (staticMetadataManager == null) {
            staticMetadataManager = (StaticMetadataManager)ApplicationContextAwareUtils.getApplicationContext().getBean(StaticMetadataManager.class);
        }
        MetadataContext metadataContext = new MetadataContext();
        metadataContext.setTransitiveMetadata(staticMetadataManager.getMergedStaticTransitiveMetadata());
        metadataContext.setDisposableMetadata(staticMetadataManager.getMergedStaticDisposableMetadata());
        if (StringUtils.hasText((String)staticMetadataManager.getTransHeaderFromEnv())) {
            metadataContext.setTransHeaders(staticMetadataManager.getTransHeaderFromEnv(), "");
        }
        METADATA_CONTEXT.set(metadataContext);
        return METADATA_CONTEXT.get();
    }

    public static Optional<String> getDisposableMetadata(String key, boolean upstream) {
        MetadataContext context = MetadataContextHolder.get();
        if (upstream) {
            return Optional.ofNullable(context.getContext("upstream-disposable", key));
        }
        return Optional.ofNullable(context.getContext("disposable", key));
    }

    public static Map<String, String> getAllDisposableMetadata(boolean upstream) {
        HashMap<String, String> disposables = new HashMap<String, String>();
        MetadataContext context = MetadataContextHolder.get();
        if (upstream) {
            disposables.putAll(context.getFragmentContext("upstream-disposable"));
        } else {
            disposables.putAll(context.getFragmentContext("disposable"));
        }
        return Collections.unmodifiableMap(disposables);
    }

    public static void set(MetadataContext metadataContext) {
        METADATA_CONTEXT.set(metadataContext);
    }

    public static void init(Map<String, String> dynamicTransitiveMetadata, Map<String, String> dynamicDisposableMetadata) {
        MetadataContextHolder.remove();
        MetadataContext metadataContext = MetadataContextHolder.get();
        if (!CollectionUtils.isEmpty(dynamicTransitiveMetadata)) {
            Map<String, String> staticTransitiveMetadata = metadataContext.getTransitiveMetadata();
            HashMap<String, String> mergedTransitiveMetadata = new HashMap<String, String>();
            mergedTransitiveMetadata.putAll(staticTransitiveMetadata);
            mergedTransitiveMetadata.putAll(dynamicTransitiveMetadata);
            metadataContext.setTransitiveMetadata(Collections.unmodifiableMap(mergedTransitiveMetadata));
        }
        if (!CollectionUtils.isEmpty(dynamicDisposableMetadata)) {
            HashMap<String, String> mergedUpstreamDisposableMetadata = new HashMap<String, String>(dynamicDisposableMetadata);
            metadataContext.setUpstreamDisposableMetadata(Collections.unmodifiableMap(mergedUpstreamDisposableMetadata));
        }
        Map<String, String> staticDisposableMetadata = metadataContext.getDisposableMetadata();
        metadataContext.setDisposableMetadata(Collections.unmodifiableMap(staticDisposableMetadata));
        MetadataContextHolder.set(metadataContext);
    }

    public static void remove() {
        METADATA_CONTEXT.remove();
    }
}

