/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util.expresstion;

import com.tencent.cloud.common.util.expresstion.ExpressionParser;
import com.tencent.cloud.common.util.expresstion.ExpressionParserV1;
import com.tencent.cloud.common.util.expresstion.ExpressionParserV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public final class ExpressionLabelUtils {
    private static final List<ExpressionParser> EXPRESSION_PARSERS = new ArrayList<ExpressionParser>(2);

    private ExpressionLabelUtils() {
    }

    public static boolean isExpressionLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isExpressionLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHeaderLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isHeaderLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static String parseHeaderKey(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isHeaderLabel(expression)) continue;
            return parser.parseHeaderKey(expression);
        }
        return "";
    }

    public static boolean isQueryLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isQueryLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static String parseQueryKey(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isQueryLabel(expression)) continue;
            return parser.parseQueryKey(expression);
        }
        return "";
    }

    public static boolean isCookieLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isCookieLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static String parseCookieKey(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isCookieLabel(expression)) continue;
            return parser.parseCookieKey(expression);
        }
        return "";
    }

    public static boolean isMethodLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isMethodLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUriLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isUriLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCallerIPLabel(String expression) {
        for (ExpressionParser parser : EXPRESSION_PARSERS) {
            if (!parser.isCallerIPLabel(expression)) continue;
            return true;
        }
        return false;
    }

    public static String getQueryValue(String queryString, String queryKey) {
        if (StringUtils.isBlank((String)queryString)) {
            return "";
        }
        String[] queries = StringUtils.split((String)queryString, (String)"&");
        if (queries == null || queries.length == 0) {
            return "";
        }
        for (String query : queries) {
            String[] queryKV = StringUtils.split((String)query, (String)"=");
            if (queryKV == null || queryKV.length != 2 || !StringUtils.equals((String)queryKV[0], (String)queryKey)) continue;
            return queryKV[1];
        }
        return "";
    }

    public static String getFirstValue(Map<String, Collection<String>> valueMaps, String key) {
        if (CollectionUtils.isEmpty(valueMaps)) {
            return "";
        }
        Collection<String> values = valueMaps.get(key);
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        Iterator<String> iterator = values.iterator();
        if (iterator.hasNext()) {
            String value = iterator.next();
            return value;
        }
        return "";
    }

    static {
        EXPRESSION_PARSERS.add(new ExpressionParserV1());
        EXPRESSION_PARSERS.add(new ExpressionParserV2());
    }
}

