/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class AddressUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressUtils.class);
    private static final String ADDRESS_SEPARATOR = ",";

    private AddressUtils() {
    }

    public static List<String> parseAddressList(String addressInfo) {
        String[] addresses;
        if (!StringUtils.hasText((String)addressInfo)) {
            return Collections.emptyList();
        }
        ArrayList<String> addressList = new ArrayList<String>();
        for (String address : addresses = addressInfo.split(ADDRESS_SEPARATOR)) {
            URI uri = URI.create(address.trim());
            addressList.add(uri.getAuthority());
        }
        return addressList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean accessible(String ip, int port, int timeout) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(InetAddress.getByName(ip), port), timeout);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("Close socket connection failed.", (Throwable)e);
            }
        }
        return true;
    }
}

