/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import com.tencent.cloud.common.util.ApplicationContextAwareUtils;

public final class DiscoveryUtil {
    private static String ENABLE_NACOS;
    private static String ENABLE_NACOS_DISCOVERY;
    private static String ENABLE_NACOS_REGISTRY;
    private static String ENABLE_POLARIS_DISCOVERY;
    private static String NACOS_GROUP;
    private static String NACOS_NAMESPACE;
    private static final Object MUTEX;
    private static boolean INITIALIZE;

    private DiscoveryUtil() {
    }

    public static String rewriteServiceId(String serviceId) {
        DiscoveryUtil.init();
        if (Boolean.parseBoolean(ENABLE_NACOS)) {
            boolean rewrite = false;
            if (Boolean.parseBoolean(ENABLE_NACOS_REGISTRY) && Boolean.parseBoolean(ENABLE_POLARIS_DISCOVERY)) {
                rewrite = true;
            }
            if (Boolean.parseBoolean(ENABLE_NACOS_DISCOVERY) || Boolean.parseBoolean(ENABLE_POLARIS_DISCOVERY)) {
                rewrite = true;
            }
            if (rewrite) {
                serviceId = NACOS_GROUP + "__" + (String)serviceId;
            }
        }
        return serviceId;
    }

    public static String rewriteNamespace(String namespace) {
        DiscoveryUtil.init();
        if (Boolean.parseBoolean(ENABLE_NACOS)) {
            boolean rewrite = false;
            if (Boolean.parseBoolean(ENABLE_NACOS_REGISTRY) && Boolean.parseBoolean(ENABLE_POLARIS_DISCOVERY)) {
                rewrite = true;
            }
            if (Boolean.parseBoolean(ENABLE_NACOS_DISCOVERY) || Boolean.parseBoolean(ENABLE_POLARIS_DISCOVERY)) {
                rewrite = true;
            }
            if (rewrite) {
                namespace = NACOS_NAMESPACE;
            }
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (INITIALIZE) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            if (INITIALIZE) {
                return;
            }
            ENABLE_NACOS = ApplicationContextAwareUtils.getProperties("spring.cloud.nacos.enabled");
            ENABLE_NACOS_DISCOVERY = ApplicationContextAwareUtils.getProperties("spring.cloud.nacos.discovery.enabled");
            ENABLE_NACOS_REGISTRY = ApplicationContextAwareUtils.getProperties("spring.cloud.nacos.discovery.register-enabled");
            ENABLE_POLARIS_DISCOVERY = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.discovery.enabled");
            NACOS_GROUP = ApplicationContextAwareUtils.getProperties("spring.cloud.nacos.discovery.group", "DEFAULT_GROUP");
            NACOS_NAMESPACE = ApplicationContextAwareUtils.getProperties("spring.cloud.nacos.discovery.namespace", "public");
            INITIALIZE = true;
        }
    }

    static {
        MUTEX = new Object();
        INITIALIZE = false;
    }
}

