/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.util.ApplicationContextAwareUtils;
import com.tencent.cloud.common.util.JacksonUtils;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class MetadataContext {
    public static String LOCAL_NAMESPACE;
    public static String LOCAL_SERVICE;
    private final Map<String, String> transitiveCustomMetadata = new ConcurrentHashMap<String, String>();
    private final Map<String, String> systemMetadata = new ConcurrentHashMap<String, String>();

    public Map<String, String> getAllTransitiveCustomMetadata() {
        return Collections.unmodifiableMap(this.transitiveCustomMetadata);
    }

    public String getTransitiveCustomMetadata(String key) {
        return this.transitiveCustomMetadata.get(key);
    }

    public void putTransitiveCustomMetadata(String key, String value) {
        this.transitiveCustomMetadata.put(key, value);
    }

    public void putAllTransitiveCustomMetadata(Map<String, String> customMetadata) {
        this.transitiveCustomMetadata.putAll(customMetadata);
    }

    public Map<String, String> getAllSystemMetadata() {
        return Collections.unmodifiableMap(this.systemMetadata);
    }

    public String getSystemMetadata(String key) {
        return this.systemMetadata.get(key);
    }

    public void putSystemMetadata(String key, String value) {
        this.systemMetadata.put(key, value);
    }

    public void putAllSystemMetadata(Map<String, String> systemMetadata) {
        this.systemMetadata.putAll(systemMetadata);
    }

    public String toString() {
        return "MetadataContext{transitiveCustomMetadata=" + JacksonUtils.serialize2Json(this.transitiveCustomMetadata) + ", systemMetadata=" + JacksonUtils.serialize2Json(this.systemMetadata) + '}';
    }

    static {
        String namespace = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.namespace");
        if (StringUtils.isEmpty((Object)namespace)) {
            namespace = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.discovery.namespace", "default");
        }
        LOCAL_NAMESPACE = namespace;
        String serviceName = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.service");
        if (StringUtils.isEmpty((Object)serviceName)) {
            serviceName = ApplicationContextAwareUtils.getProperties("spring.cloud.polaris.discovery.service", ApplicationContextAwareUtils.getProperties("spring.application.name", null));
        }
        LOCAL_SERVICE = serviceName;
    }
}

